/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import igentuman.nc.NuclearCraft;
import igentuman.nc.recipes.NcRecipeSerializers;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.type.NcRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class NcRecipeSerializer<RECIPE extends NcRecipe>
implements RecipeSerializer<RECIPE> {
    final IFactory<RECIPE> factory;
    protected ItemStackIngredient[] inputItems;
    protected ItemStackIngredient[] outputItems;
    protected FluidStackIngredient[] inputFluids;
    protected FluidStackIngredient[] outputFluids;

    public NcRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray output;
        JsonObject inputJson;
        int i;
        JsonArray input;
        block27: {
            this.inputItems = new ItemStackIngredient[0];
            try {
                if (json.has("input")) {
                    if (GsonHelper.m_13885_((JsonObject)json, (String)"input")) {
                        input = GsonHelper.m_13933_((JsonObject)json, (String)"input");
                        this.inputItems = new ItemStackIngredient[input.getAsJsonArray().size()];
                        i = 0;
                        for (JsonElement in : input.getAsJsonArray()) {
                            this.inputItems[i] = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize(in);
                            ++i;
                        }
                    } else {
                        inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"input");
                        this.inputItems = new ItemStackIngredient[]{(ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)inputJson)};
                    }
                }
            }
            catch (Exception ex) {
                NuclearCraft.LOGGER.warn("Unable to parse input for recipe: " + recipeId);
            }
            this.outputItems = new ItemStackIngredient[0];
            try {
                if (!json.has("output")) break block27;
                if (GsonHelper.m_13885_((JsonObject)json, (String)"output")) {
                    output = GsonHelper.m_13933_((JsonObject)json, (String)"output");
                    this.outputItems = new ItemStackIngredient[output.getAsJsonArray().size()];
                    i = 0;
                    for (JsonElement out : output.getAsJsonArray()) {
                        try {
                            this.outputItems[i] = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize(out);
                        }
                        catch (JsonSyntaxException ex) {
                            NuclearCraft.LOGGER.error("Error parsing output itemstack for recipe: " + recipeId.toString());
                        }
                        ++i;
                    }
                    break block27;
                }
                output = GsonHelper.m_13930_((JsonObject)json, (String)"output");
                this.outputItems = new ItemStackIngredient[]{(ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)output.getAsJsonObject())};
            }
            catch (Exception ex) {
                NuclearCraft.LOGGER.warn("Unable to parse output for recipe: " + recipeId);
            }
        }
        this.inputFluids = new FluidStackIngredient[0];
        try {
            if (json.has("inputFluids")) {
                if (GsonHelper.m_13885_((JsonObject)json, (String)"inputFluids")) {
                    input = GsonHelper.m_13933_((JsonObject)json, (String)"inputFluids");
                    this.inputFluids = new FluidStackIngredient[input.getAsJsonArray().size()];
                    i = 0;
                    for (JsonElement in : input.getAsJsonArray()) {
                        this.inputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize(in);
                        ++i;
                    }
                } else {
                    inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"inputFluids");
                    this.inputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)inputJson)};
                }
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse input fluid for recipe: " + recipeId);
        }
        this.outputFluids = new FluidStackIngredient[0];
        try {
            if (json.has("outputFluids")) {
                if (GsonHelper.m_13885_((JsonObject)json, (String)"outputFluids")) {
                    output = GsonHelper.m_13933_((JsonObject)json, (String)"outputFluids");
                    this.outputFluids = new FluidStackIngredient[output.getAsJsonArray().size()];
                    i = 0;
                    for (JsonElement out : output.getAsJsonArray()) {
                        this.outputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)out.getAsJsonObject());
                        ++i;
                    }
                } else {
                    output = GsonHelper.m_13930_((JsonObject)json, (String)"outputFluids");
                    this.outputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)output.getAsJsonObject())};
                }
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse output fluid for recipe: " + recipeId);
        }
        double timeModifier = 1.0;
        double powerModifier = 1.0;
        double radiation = 1.0;
        double rarityModifier = 1.0;
        double temperature = 1.0;
        try {
            timeModifier = GsonHelper.m_144742_((JsonObject)json, (String)"timeModifier", (double)1.0);
            powerModifier = GsonHelper.m_144742_((JsonObject)json, (String)"powerModifier", (double)1.0);
            radiation = GsonHelper.m_144742_((JsonObject)json, (String)"radiation", (double)1.0);
            rarityModifier = GsonHelper.m_144742_((JsonObject)json, (String)"rarityModifier", (double)1.0);
            temperature = GsonHelper.m_144742_((JsonObject)json, (String)"temperature", (double)1.0);
            if (temperature > 1.0) {
                rarityModifier = temperature;
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse params for recipe: " + recipeId);
        }
        return this.factory.create(recipeId, this.inputItems, this.outputItems, this.inputFluids, this.outputFluids, timeModifier, powerModifier, radiation, rarityModifier);
    }

    public void readIngredients(@NotNull FriendlyByteBuf buffer) {
        int i;
        int inputSize = buffer.readInt();
        this.inputItems = new ItemStackIngredient[inputSize];
        for (int i2 = 0; i2 < inputSize; ++i2) {
            this.inputItems[i2] = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        }
        int outputSize = buffer.readInt();
        this.outputItems = new ItemStackIngredient[outputSize];
        for (i = 0; i < outputSize; ++i) {
            this.outputItems[i] = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        }
        inputSize = buffer.readInt();
        this.inputFluids = new FluidStackIngredient[inputSize];
        for (i = 0; i < inputSize; ++i) {
            this.inputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        }
        outputSize = buffer.readInt();
        this.outputFluids = new FluidStackIngredient[outputSize];
        for (i = 0; i < outputSize; ++i) {
            this.outputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        }
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        if (recipeId.m_135815_().contains("nc_ore_veins")) {
            return (RECIPE)((NcRecipe)((RecipeSerializer)NcRecipeSerializers.SERIALIZERS.get("nc_ore_veins").get()).m_8005_(recipeId, buffer));
        }
        try {
            this.readIngredients(buffer);
            double timeModifier = buffer.readDouble();
            double powerModifier = buffer.readDouble();
            double radiation = buffer.readDouble();
            return this.factory.create(recipeId, this.inputItems, this.outputItems, this.inputFluids, this.outputFluids, timeModifier, powerModifier, radiation, 1.0);
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error reading recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((NcRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error writing recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends NcRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient[] var2, ItemStackIngredient[] var3, FluidStackIngredient[] var4, FluidStackIngredient[] var5, double var6, double var8, double var10, double var12);
    }
}

