/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.block.BatteryBlock;
import igentuman.nc.block.RTGBlock;
import igentuman.nc.block.SolarPanelBlock;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.content.energy.BatteryBlocks;
import igentuman.nc.content.energy.RTGs;
import igentuman.nc.content.energy.SolarPanels;
import igentuman.nc.item.BatteryBlockItem;
import igentuman.nc.setup.Registration;
import java.util.HashMap;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NCEnergyBlocks {
    public static HashMap<String, RegistryObject<Block>> ENERGY_BLOCKS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> BLOCK_ITEMS = new HashMap();
    public static final Item.Properties ENERGY_ITEM_PROPERTIES = new Item.Properties();
    public static final BlockBehaviour.Properties ENERGY_BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_();
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"nuclearcraft");
    public static HashMap<String, RegistryObject<BlockEntityType<? extends NCEnergy>>> ENERGY_BE = new HashMap();

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_ENTITIES.register(bus);
        NCEnergyBlocks.registerBlocks();
        NCEnergyBlocks.registerBlockEntities();
    }

    private static void registerBlockEntities() {
        for (String name : SolarPanels.registered().keySet()) {
            String key = "solar_panel/" + name;
            ENERGY_BE.put(key, (RegistryObject<BlockEntityType<? extends NCEnergy>>)BLOCK_ENTITIES.register(key, () -> BlockEntityType.Builder.m_155273_(SolarPanels.all().get(name).getBlockEntity(), (Block[])new Block[]{(Block)ENERGY_BLOCKS.get(key).get()}).m_58966_(null)));
        }
        for (String name : BatteryBlocks.registered().keySet()) {
            ENERGY_BE.put(name, (RegistryObject<BlockEntityType<? extends NCEnergy>>)BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_(BatteryBlocks.all().get(name).getBlockEntity(), (Block[])new Block[]{(Block)ENERGY_BLOCKS.get(name).get()}).m_58966_(null)));
        }
        for (String name : RTGs.registered().keySet()) {
            ENERGY_BE.put(name, (RegistryObject<BlockEntityType<? extends NCEnergy>>)BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_(RTGs.all().get(name).getBlockEntity(), (Block[])new Block[]{(Block)ENERGY_BLOCKS.get(name).get()}).m_58966_(null)));
        }
    }

    private static void registerBlocks() {
        for (String name : SolarPanels.registered().keySet()) {
            String key = "solar_panel/" + name;
            ENERGY_BLOCKS.put(key, (RegistryObject<Block>)Registration.BLOCKS.register(key.replace("/", "_"), () -> new SolarPanelBlock(ENERGY_BLOCK_PROPERTIES)));
            BLOCK_ITEMS.put(key, NCEnergyBlocks.fromBlock(ENERGY_BLOCKS.get(key)));
        }
        for (String name : BatteryBlocks.registered().keySet()) {
            ENERGY_BLOCKS.put(name, (RegistryObject<Block>)Registration.BLOCKS.register(name, () -> new BatteryBlock(ENERGY_BLOCK_PROPERTIES)));
            BLOCK_ITEMS.put(name, NCEnergyBlocks.fromBatteryBlock(ENERGY_BLOCKS.get(name)));
        }
        for (String name : RTGs.registered().keySet()) {
            ENERGY_BLOCKS.put(name, (RegistryObject<Block>)Registration.BLOCKS.register(name, () -> new RTGBlock(ENERGY_BLOCK_PROPERTIES)));
            BLOCK_ITEMS.put(name, NCEnergyBlocks.fromBlock(ENERGY_BLOCKS.get(name)));
        }
    }

    public static <B extends Block> RegistryObject<Item> fromBatteryBlock(RegistryObject<B> block) {
        return Registration.ITEMS.register(block.getId().m_135815_(), () -> new BatteryBlockItem((Block)block.get(), ENERGY_ITEM_PROPERTIES));
    }

    public static <B extends Block> RegistryObject<Item> fromBlock(RegistryObject<B> block) {
        return Registration.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), ENERGY_ITEM_PROPERTIES));
    }
}

