/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import com.google.common.collect.ImmutableList;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.NCFluidBlock;
import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.fluid.AcidDefinition;
import igentuman.nc.fluid.GasDefinition;
import igentuman.nc.fluid.LiquidDefinition;
import igentuman.nc.fluid.NCFluid;
import igentuman.nc.item.NCBucketItem;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextureUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class NCFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"nuclearcraft");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"nuclearcraft");
    public static final HashMap<String, FluidEntry> ALL_FLUID_ENTRIES = new HashMap();
    public static final Set<NCBlocks.BlockEntry<? extends LiquidBlock>> ALL_FLUID_BLOCKS = new HashSet<NCBlocks.BlockEntry<? extends LiquidBlock>>();
    public static HashMap<String, FluidEntry> NC_MATERIALS = new HashMap();
    public static HashMap<String, FluidEntry> NC_GASES = new HashMap();
    public static HashMap<String, TagKey<Fluid>> GASES_TAG = new HashMap();
    public static HashMap<String, TagKey<Fluid>> LIQUIDS_TAG = new HashMap();

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
    }

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FLUIDS.register(bus);
        FLUID_TYPES.register(bus);
        NCFluids.materialFluids();
        NCFluids.gases();
        NCFluids.fuel();
        NCFluids.isotopes();
        NCFluids.acids();
        NCFluids.liquidGases();
        NCFluids.liquids();
        NCFluids.slurryFluids();
    }

    public static BlockState getBlock(String name) {
        if (NC_MATERIALS.containsKey(name)) {
            return NC_MATERIALS.get(name).getBlock().m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    private static void liquids() {
        HashMap<String, LiquidDefinition> items = new HashMap<String, LiquidDefinition>();
        if (ModUtil.isMekanismLoadeed()) {
            items.put("spent_nuclear_waste", new LiquidDefinition("spent_nuclear_waste", -1877009644));
            items.put("nuclear_waste", new LiquidDefinition("nuclear_waste", -1875037405));
            items.put("fissile_fuel", new LiquidDefinition("fissile_fuel", -1875037405));
        }
        items.put("irradiated_boron", new LiquidDefinition("irradiated_boron", -9467540, 800));
        items.put("irradiated_lithium", new LiquidDefinition("irradiated_lithium", -4405663, 800));
        items.put("uranium_oxide", new LiquidDefinition("uranium_oxide", -1867926204));
        items.put("cryotheum", new LiquidDefinition("cryotheum", -1870008833));
        items.put("radaway", new LiquidDefinition("radaway", 1353939652));
        items.put("ethanol", new LiquidDefinition("ethanol", 1353939652));
        items.put("methanol", new LiquidDefinition("methanol", 1353939652));
        items.put("sodium", new LiquidDefinition("sodium", 1356687708));
        items.put("glowstone", new LiquidDefinition("glowstone", 1356259615));
        items.put("redstone", new LiquidDefinition("redstone", 0x50E50E0E));
        items.put("hydrogen_chloride", new LiquidDefinition("hydrogen_chloride", 1353939652));
        items.put("lithium_fluoride", new LiquidDefinition("lithium_fluoride", 1353939652));
        items.put("beryllium_fluoride", new LiquidDefinition("beryllium_fluoride", 1353939652));
        items.put("radaway_slow", new LiquidDefinition("radaway_slow", 1352724479));
        items.put("redstone_ethanol", new LiquidDefinition("redstone_ethanol", 1350470856));
        items.put("boron_nitride_solution", new LiquidDefinition("boron_nitride_solution", 1349488220));
        items.put("boron_arsenide_solution", new LiquidDefinition("boron_arsenide_solution", 1349488220));
        items.put("fluorite_water", new LiquidDefinition("fluorite_water", 1351267474));
        items.put("calcium_sulfate_solution", new LiquidDefinition("calcium_sulfate_solution", 1354281126));
        items.put("sodium_fluoride_solution", new LiquidDefinition("sodium_fluoride_solution", 1354936737));
        items.put("potassium_fluoride_solution", new LiquidDefinition("potassium_fluoride_solution", 1354877341));
        items.put("sodium_hydroxide_solution", new LiquidDefinition("sodium_hydroxide_solution", 1354938299));
        items.put("potassium_hydroxide_solution", new LiquidDefinition("potassium_hydroxide_solution", 1354286768));
        items.put("borax_solution", new LiquidDefinition("borax_solution", 0x50EEEEEE));
        items.put("irradiated_borax_solution", new LiquidDefinition("irradiated_borax_solution", -1862283101));
        items.put("ice", new LiquidDefinition("ice", -1867517441));
        items.put("slurry_ice", new LiquidDefinition("slurry_ice", -1870745929));
        items.put("heavy_water", new LiquidDefinition("heavy_water", -2139181385));
        items.put("chocolate_liquor", new LiquidDefinition("chocolate_liquor", -12508132));
        items.put("cocoa_butter", new LiquidDefinition("cocoa_butter", -594241));
        items.put("unsweetened_chocolate", new LiquidDefinition("unsweetened_chocolate", -13891064));
        items.put("dark_chocolate", new LiquidDefinition("dark_chocolate", -13890810));
        items.put("milk_chocolate", new LiquidDefinition("milk_chocolate", -7847647));
        items.put("sugar", new LiquidDefinition("sugar", 1358943642));
        items.put("gelatin", new LiquidDefinition("gelatin", 1356714140));
        items.put("hydrated_gelatin", new LiquidDefinition("hydrated_gelatin", 1356714140));
        items.put("marshmallow", new LiquidDefinition("marshmallow", -1864244765));
        items.put("pasteurized_milk", new LiquidDefinition("pasteurized_milk", -3342));
        items.put("technical_water", new LiquidDefinition("technical_water", -1875950604));
        items.put("condensate_water", new LiquidDefinition("condensate_water", -1875950604));
        items.put("emergency_coolant", new LiquidDefinition("emergency_coolant", -1871851289));
        items.put("emergency_coolant_heated", new LiquidDefinition("emergency_coolant_heated", -1865564441));
        for (LiquidDefinition liquid : items.values()) {
            LIQUIDS_TAG.put(liquid.name, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", liquid.name)));
            NC_MATERIALS.put(liquid.name, FluidEntry.makeLiquid(liquid.name, liquid.color));
        }
    }

    private static void liquidGases() {
        HashMap<String, LiquidDefinition> items = new HashMap<String, LiquidDefinition>();
        items.put("liquid_hydrogen", new LiquidDefinition("liquid_hydrogen", 1353939652));
        items.put("liquid_helium", new LiquidDefinition("liquid_helium", 1352724479));
        items.put("liquid_oxygen", new LiquidDefinition("liquid_oxygen", 1350470856));
        items.put("liquid_nitrogen", new LiquidDefinition("liquid_nitrogen", 1345438266));
        for (LiquidDefinition liquid : items.values()) {
            LIQUIDS_TAG.put(liquid.name, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", liquid.name)));
            NC_MATERIALS.put(liquid.name, FluidEntry.makeLiquid(liquid.name, liquid.color));
        }
    }

    private static void slurryFluids() {
        HashMap<CallSite, AcidDefinition> items = new HashMap<CallSite, AcidDefinition>();
        int id = 0;
        for (String material : Materials.slurries()) {
            int color = FMLEnvironment.dist.isClient() ? TextureUtil.getAverageColor("textures/block/ore/" + material + "_ore.png") : TextureUtil.getAverageColorServer("textures/block/ore/" + material + "_ore.png");
            int[] rgba = TextureUtil.intToRgba(color);
            if (rgba[0] == 0 && rgba[1] == 0 && rgba[2] == 0) {
                Random rand = new Random(material.length() + id);
                rgba = new int[]{rand.nextInt(id + 254), rand.nextInt(id + 255), rand.nextInt(id + 253), 255};
            }
            rgba[3] = 254;
            items.put((CallSite)((Object)(material + "_slurry")), new AcidDefinition(material + "_slurry", TextureUtil.rgbaToInt(rgba)));
            rgba[3] = 221;
            items.put((CallSite)((Object)(material + "_clean_slurry")), new AcidDefinition(material + "_clean_slurry", TextureUtil.rgbaToInt(rgba)));
        }
        for (AcidDefinition acid : items.values()) {
            LIQUIDS_TAG.put(acid.name, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", acid.name)));
            NC_MATERIALS.put(acid.name, FluidEntry.makeAcid(acid));
        }
    }

    private static void acids() {
        HashMap<String, AcidDefinition> items = new HashMap<String, AcidDefinition>();
        items.put("hydrofluoric_acid", new AcidDefinition("hydrofluoric_acid", -855642471));
        items.put("hydrochloric_acid", new AcidDefinition("hydrochloric_acid", -1141969153));
        items.put("boric_acid", new AcidDefinition("boric_acid", -861868033));
        items.put("sulfuric_acid", new AcidDefinition("sulfuric_acid", -856096813));
        items.put("nitric_acid", new AcidDefinition("nitric_acid", -867197185));
        items.put("aqua_regia_acid", new AcidDefinition("aqua_regia_acid", -855655527));
        for (AcidDefinition acid : items.values()) {
            LIQUIDS_TAG.put(acid.name, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", acid.name)));
            NC_MATERIALS.put(acid.name, FluidEntry.makeAcid(acid));
        }
    }

    private static void materialFluids() {
        for (String name : Materials.fluids().keySet()) {
            LIQUIDS_TAG.put(name, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", name)));
            NC_MATERIALS.put(name, FluidEntry.makeMoltenLiquid(name, Materials.fluids().get((Object)name).color));
        }
    }

    private static void fuel() {
        for (String name : FuelManager.all().keySet()) {
            for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : new String[]{"", "_za", "_ox", "_ni"}) {
                    String key = "fuel_" + name + "_" + subType + type;
                    if (NC_MATERIALS.containsKey(key)) continue;
                    int colorDepleted = -3355444;
                    int colorFuel = -3355444;
                    if (FMLEnvironment.dist.isClient()) {
                        colorDepleted = TextureUtil.getAverageColor("textures/item/fuel/" + name + "/depleted/" + subType.replace("-", "_") + type + ".png");
                        colorFuel = TextureUtil.getAverageColor("textures/item/fuel/" + name + "/" + subType.replace("-", "_") + type + ".png");
                    }
                    NC_MATERIALS.put(key, FluidEntry.makeMoltenLiquid(key.replace("-", "_"), colorFuel));
                    LIQUIDS_TAG.put(key, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", key.replace("-", "_"))));
                    NC_MATERIALS.put("depleted_" + key, FluidEntry.makeMoltenLiquid("depleted_" + key.replace("-", "_"), colorDepleted));
                    LIQUIDS_TAG.put("depleted_" + key, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", "depleted_" + key.replace("-", "_"))));
                }
            }
        }
    }

    private static void gases() {
        HashMap<String, GasDefinition> items = new HashMap<String, GasDefinition>();
        items.put("steam", new GasDefinition("steam", -862809454));
        items.put("high_pressure_steam", new GasDefinition("high_pressure_steam", -859980355));
        items.put("exhaust_steam", new GasDefinition("exhaust_steam", -864125314));
        items.put("low_pressure_steam", new GasDefinition("low_pressure_steam", -861362008));
        items.put("low_quality_steam", new GasDefinition("low_quality_steam", -863862142));
        items.put("argon", new GasDefinition("argon", -855673379));
        items.put("neon", new GasDefinition("neon", -855662726));
        items.put("chlorine", new GasDefinition("chlorine", -855638129));
        items.put("nitric_oxide", new GasDefinition("nitric_oxide", -859181313));
        items.put("nitrogen_dioxide", new GasDefinition("nitrogen_dioxide", -864540144));
        items.put("hydrogen", new GasDefinition("hydrogen", -861868033));
        items.put("helium", new GasDefinition("helium", -859473023));
        items.put("helium_3", new GasDefinition("helium_3", -859063449));
        items.put("tritium", new GasDefinition("tritium", -866272298));
        items.put("deuterium", new GasDefinition("deuterium", -862031889));
        items.put("oxygen", new GasDefinition("oxygen", -864121656));
        items.put("nitrogen", new GasDefinition("nitrogen", -864238725));
        items.put("fluorine", new GasDefinition("fluorine", -858536099));
        items.put("carbon", new GasDefinition("carbon", -866360486));
        items.put("carbon_dioxide", new GasDefinition("carbon_dioxide", -866360486));
        items.put("carbon_monoxide", new GasDefinition("carbon_monoxide", -867412407));
        items.put("ethene", new GasDefinition("ethene", -855645021));
        items.put("fluoromethane", new GasDefinition("fluoromethane", -868070395));
        items.put("ammonia", new GasDefinition("ammonia", -864369760));
        items.put("oxygen_difluoride", new GasDefinition("oxygen_difluoride", -857072895));
        items.put("diborane", new GasDefinition("diborane", -859017588));
        items.put("sulfur_dioxide", new GasDefinition("sulfur_dioxide", -859587462));
        items.put("sulfur_trioxide", new GasDefinition("sulfur_trioxide", -858542499));
        items.put("radon", new GasDefinition("radon", -1));
        for (GasDefinition gas : items.values()) {
            LIQUIDS_TAG.put(gas.name, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", gas.name)));
            GASES_TAG.put(gas.name, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", "gases/" + gas.name)));
            NC_GASES.put(gas.name, FluidEntry.makeGas(gas));
        }
    }

    private static void isotopes() {
        for (String name : Materials.isotopes()) {
            for (String type : new String[]{"", "_za", "_ox", "_ni"}) {
                if (NC_MATERIALS.containsKey(name + type)) continue;
                int color = -3355444;
                if (FMLEnvironment.dist.isClient()) {
                    color = TextureUtil.getAverageColor("textures/item/material/isotope/" + name + type + ".png");
                }
                NC_MATERIALS.put(name + type, FluidEntry.makeMoltenLiquid(name.replace("/", "_") + type, color));
                LIQUIDS_TAG.put(name + type, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", name + type)));
            }
        }
    }

    public static Consumer<FluidType.Properties> meltBuilder(int temperature) {
        int light = 1;
        int density = 2000;
        int visconsity = 3000;
        return builder -> builder.temperature(temperature).density(density).viscosity(visconsity).lightLevel(light);
    }

    public static Consumer<FluidType.Properties> liquidBuilder(int temperature) {
        int density = 400;
        int visconsity = 1000;
        return builder -> builder.temperature(temperature).density(density).viscosity(visconsity);
    }

    public static Consumer<FluidType.Properties> gasBuilder(int temperature) {
        int density = -1000;
        int visconsity = 0;
        return builder -> builder.temperature(temperature).density(density).viscosity(visconsity);
    }

    public record FluidEntry(RegistryObject<NCFluid> flowing, RegistryObject<NCFluid> still, NCBlocks.BlockEntry<NCFluidBlock> block, RegistryObject<BucketItem> bucket, RegistryObject<FluidType> type, List<Property<?>> properties, int color) {
        public static final List<RegistryObject<BucketItem>> ALL_BUCKETS = new ArrayList<RegistryObject<BucketItem>>();

        public static FluidEntry makeAcid(AcidDefinition acid) {
            return FluidEntry.make(acid.name, 0, NuclearCraft.rl("block/material/fluid/liquid_still"), NuclearCraft.rl("block/material/fluid/liquid_flow"), NCFluids.liquidBuilder(acid.temperature), acid.color, false);
        }

        public static FluidEntry makeGas(GasDefinition gas) {
            return FluidEntry.make(gas.name, 0, NuclearCraft.rl("block/material/fluid/gas"), NuclearCraft.rl("block/material/fluid/gas"), NCFluids.gasBuilder(gas.temperature), gas.color, true);
        }

        private static FluidEntry makeMoltenLiquid(String name, int color) {
            return FluidEntry.make(name, 0, NuclearCraft.rl("block/material/fluid/molten_still"), NuclearCraft.rl("block/material/fluid/molten_flow"), NCFluids.meltBuilder(1000), color, false);
        }

        private static FluidEntry makeLiquid(String name, int color) {
            return FluidEntry.make(name, 0, NuclearCraft.rl("block/material/fluid/liquid_still"), NuclearCraft.rl("block/material/fluid/liquid_flow"), NCFluids.liquidBuilder(400), color, false);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, int color) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, color);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, -1);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Consumer<FluidType.Properties> buildAttributes) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, buildAttributes, -1, false);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, int color) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, null, color, false);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidType.Properties> buildAttributes, int color, boolean isGas) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, NCFluid::new, NCFluid.Flowing::new, buildAttributes, ImmutableList.of(), color, isGas);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends NCFluid> makeStill, Function<FluidEntry, ? extends NCFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, ImmutableList<Property<?>> properties, int color) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, makeStill, makeFlowing, buildAttributes, properties, color, false);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends NCFluid> makeStill, Function<FluidEntry, ? extends NCFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties, int color, boolean isGas) {
            FluidType.Properties builder = FluidType.Properties.create();
            if (isGas || name.contains("acid")) {
                builder.sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11937_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_);
            }
            if (buildAttributes != null) {
                buildAttributes.accept(builder);
            }
            RegistryObject type = color == -1 ? FLUID_TYPES.register(name, () -> FluidEntry.makeTypeWithTextures(builder, stillTex, flowingTex)) : FLUID_TYPES.register(name, () -> FluidEntry.makeColoredTypeWithTextures(builder, stillTex, flowingTex, color));
            MutableObject thisMutable = new MutableObject();
            RegistryObject still = FLUIDS.register(name, () -> FluidEntry.lambda$make$2(makeStill, (Mutable)thisMutable));
            RegistryObject flowing = FLUIDS.register(name + "_flowing", () -> FluidEntry.lambda$make$3(makeFlowing, (Mutable)thisMutable));
            NCBlocks.BlockEntry<NCFluidBlock> block = new NCBlocks.BlockEntry<NCFluidBlock>(name + "_fluid_block", () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_().m_60910_(), arg_0 -> FluidEntry.lambda$make$5((Mutable)thisMutable, arg_0));
            RegistryObject bucket = NCItems.ITEMS.register(name + "_bucket", () -> FluidEntry.makeBucket((RegistryObject<NCFluid>)still, burnTime));
            ALL_BUCKETS.add((RegistryObject<BucketItem>)bucket);
            FluidEntry entry = new FluidEntry((RegistryObject<NCFluid>)flowing, (RegistryObject<NCFluid>)still, block, (RegistryObject<BucketItem>)bucket, (RegistryObject<FluidType>)type, properties, color);
            thisMutable.setValue((Object)entry);
            ALL_FLUID_BLOCKS.add(block);
            ALL_FLUID_ENTRIES.put(name, entry);
            return entry;
        }

        private static FluidType makeColoredTypeWithTextures(FluidType.Properties builder, final ResourceLocation stillTex, final ResourceLocation flowingTex, final int color) {
            return new FluidType(builder){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public ResourceLocation getStillTexture() {
                            return stillTex;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return flowingTex;
                        }

                        public int getTintColor() {
                            return color;
                        }
                    });
                }
            };
        }

        private static FluidType makeTypeWithTextures(FluidType.Properties builder, final ResourceLocation stillTex, final ResourceLocation flowingTex) {
            return new FluidType(builder){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public ResourceLocation getStillTexture() {
                            return stillTex;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return flowingTex;
                        }
                    });
                }
            };
        }

        public NCFluid getFlowing() {
            return (NCFluid)((Object)this.flowing.get());
        }

        public NCFluid getStill() {
            return (NCFluid)((Object)this.still.get());
        }

        public NCFluidBlock getBlock() {
            return this.block.get();
        }

        public BucketItem getBucket() {
            return (BucketItem)this.bucket.get();
        }

        private static BucketItem makeBucket(RegistryObject<NCFluid> still, final int burnTime) {
            return new NCBucketItem((Supplier)still, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_)){

                public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
                    return burnTime;
                }
            };
        }

        public RegistryObject<NCFluid> getStillGetter() {
            return this.still;
        }

        private static /* synthetic */ NCFluidBlock lambda$make$5(Mutable thisMutable, BlockBehaviour.Properties p) {
            return new NCFluidBlock((FluidEntry)thisMutable.getValue(), p);
        }

        private static /* synthetic */ NCFluid lambda$make$3(Function makeFlowing, Mutable thisMutable) {
            return NCFluid.makeFluid(makeFlowing, (FluidEntry)thisMutable.getValue());
        }

        private static /* synthetic */ NCFluid lambda$make$2(Function makeStill, Mutable thisMutable) {
            return NCFluid.makeFluid(makeStill, (FluidEntry)thisMutable.getValue());
        }
    }
}

