/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.content.ArmorMaterials;
import igentuman.nc.content.materials.Chunks;
import igentuman.nc.content.materials.Dusts;
import igentuman.nc.content.materials.Gems;
import igentuman.nc.content.materials.Ingots;
import igentuman.nc.content.materials.Nuggets;
import igentuman.nc.content.materials.Plates;
import igentuman.nc.item.BatteryItem;
import igentuman.nc.item.DosimiterItem;
import igentuman.nc.item.GeigerCounterItem;
import igentuman.nc.item.HEVItem;
import igentuman.nc.item.HazmatItem;
import igentuman.nc.item.MultitoolItem;
import igentuman.nc.item.PaxelItem;
import igentuman.nc.item.QNP;
import igentuman.nc.item.RadAwayItem;
import igentuman.nc.item.RadShieldingItem;
import igentuman.nc.item.ResearchPaperItem;
import igentuman.nc.item.Tiers;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCSounds;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NCItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nuclearcraft");
    public static HashMap<String, RegistryObject<Item>> NC_FOOD = new HashMap();
    public static HashMap<String, RegistryObject<Item>> ALL_NC_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_RECORDS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_PARTS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_SHIELDING = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_GEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_INGOTS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_CHUNKS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_NUGGETS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_PLATES = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_DUSTS = new HashMap();
    public static TagKey<Item> PLATE_TAG = TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "plates"));
    public static TagKey<Item> PARTS_TAG = TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("nuclearcraft", "parts"));
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties();
    public static final Item.Properties ONE_ITEM_PROPERTIES = new Item.Properties().m_41487_(1);
    public static final Item.Properties PAXEL_PROPS = new Item.Properties().m_41487_(1).m_41503_(5000);
    public static final Item.Properties HAZMAT_PROPS = new Item.Properties().m_41487_(1).m_41503_(250);
    public static final Item.Properties TOUGH_PROPS = new Item.Properties().m_41487_(1).m_41503_(2500);
    public static final Item.Properties HEV_PROPS = new Item.Properties().m_41487_(1).m_41503_(5500);
    public static final RegistryObject<Item> HAZMAT_MASK = ITEMS.register("hazmat_mask", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.HELMET, HAZMAT_PROPS));
    public static final RegistryObject<Item> HAZMAT_CHEST = ITEMS.register("hazmat_chest", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.CHESTPLATE, HAZMAT_PROPS));
    public static final RegistryObject<Item> HAZMAT_BOOTS = ITEMS.register("hazmat_boots", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.BOOTS, HAZMAT_PROPS));
    public static final RegistryObject<Item> HAZMAT_PANTS = ITEMS.register("hazmat_pants", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.LEGGINGS, HAZMAT_PROPS));
    public static final RegistryObject<Item> HEV_HELMET = ITEMS.register("hev_helmet", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.HELMET, HEV_PROPS));
    public static final RegistryObject<Item> HEV_CHEST = ITEMS.register("hev_chest", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.CHESTPLATE, HEV_PROPS));
    public static final RegistryObject<Item> HEV_BOOTS = ITEMS.register("hev_boots", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.BOOTS, HEV_PROPS));
    public static final RegistryObject<Item> HEV_PANTS = ITEMS.register("hev_pants", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.LEGGINGS, HEV_PROPS));
    public static final RegistryObject<Item> TOUGH_HELMET = ITEMS.register("tough_helmet", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.HELMET, TOUGH_PROPS));
    public static final RegistryObject<Item> TOUGH_CHEST = ITEMS.register("tough_chest", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.CHESTPLATE, TOUGH_PROPS));
    public static final RegistryObject<Item> TOUGH_BOOTS = ITEMS.register("tough_boots", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.BOOTS, TOUGH_PROPS));
    public static final RegistryObject<Item> TOUGH_PANTS = ITEMS.register("tough_pants", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.LEGGINGS, TOUGH_PROPS));
    public static final RegistryObject<Item> GEIGER_COUNTER = ITEMS.register("geiger_counter", () -> new GeigerCounterItem(ONE_ITEM_PROPERTIES));
    public static final RegistryObject<Item> LITHIUM_ION_CELL = ITEMS.register("lithium_ion_cell", () -> new BatteryItem(ONE_ITEM_PROPERTIES));
    public static final RegistryObject<Item> SPAXELHOE_TOUGH = ITEMS.register("spaxelhoe_tough", () -> new PaxelItem(7.0f, 2.0f, Tiers.TOUGH, PAXEL_PROPS));
    public static final RegistryObject<Item> SPAXELHOE_THORIUM = ITEMS.register("spaxelhoe_thorium", () -> new PaxelItem(3.0f, 1.0f, Tiers.THORIUM, PAXEL_PROPS));
    public static final RegistryObject<Item> QNP = ITEMS.register("qnp", () -> new QNP(Tiers.QNP, 11, 2.0f, ONE_ITEM_PROPERTIES));
    public static final RegistryObject<Item> MULTITOOL = ITEMS.register("multitool", () -> new MultitoolItem(ONE_ITEM_PROPERTIES));
    public static HashMap<String, TagKey<Item>> INGOTS_TAG = new HashMap();
    public static HashMap<String, TagKey<Item>> CHUNKS_TAG = new HashMap();
    public static HashMap<String, TagKey<Item>> GEMS_TAG = new HashMap();
    public static HashMap<String, TagKey<Item>> NUGGETS_TAG = new HashMap();
    public static HashMap<String, TagKey<Item>> PLATES_TAG = new HashMap();
    public static HashMap<String, TagKey<Item>> DUSTS_TAG = new HashMap();

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        NCItems.registerChunks();
        NCItems.registerNuggets();
        NCItems.registerIngots();
        NCItems.registerPlates();
        NCItems.registerDusts();
        NCItems.registerGems();
        NCItems.registerParts();
        NCItems.registerItems();
        NCItems.registerFood();
        NCItems.registerRecords();
        NCItems.registerShielding();
    }

    private static void registerRecords() {
        List<String> items = Arrays.asList("end_of_the_world", "hyperspace", "money_for_nothing", "wanderer");
        for (String name : items) {
            NC_RECORDS.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new RecordItem(15, (Supplier)NCSounds.SOUND_MAP.get(name), ITEM_PROPERTIES, 300)));
            ALL_NC_ITEMS.put(name, NC_RECORDS.get(name));
        }
    }

    private static void registerFood() {
        List<String> items = Arrays.asList("marshmallow", "milk_chocolate", "dark_chocolate", "graham_cracker", "smore", "moresmore", "foursmore", "dominos", "evenmoresmore");
        int i = -18;
        for (String name : items) {
            int finalI = Math.max(i += 4, 1);
            NC_FOOD.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(finalI).m_38758_((float)finalI).m_38767_()))));
            ALL_NC_ITEMS.put(name, NC_FOOD.get(name));
        }
        for (String name : List.of("rad_x", "radaway", "radaway_slow")) {
            NC_FOOD.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new RadAwayItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_()))));
            ALL_NC_ITEMS.put(name, NC_FOOD.get(name));
        }
    }

    private static void registerItems() {
        List<String> items = Arrays.asList("cocoa_butter", "cocoa_solids", "roasted_cocoa_beans", "flour", "gelatin", "ground_cocoa_nibs", "salt", "sawdust", "dosimeter", "upgrade_energy", "upgrade_speed", "water_collector", "lava_collector", "compact_water_collector", "dense_water_collector", "helium_collector", "compact_helium_collector", "dense_helium_collector", "nitrogen_collector", "compact_nitrogen_collector", "dense_nitrogen_collector", "unsweetened_chocolate");
        for (String name : items) {
            if (name.equals("dosimeter")) {
                NC_ITEMS.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new DosimiterItem(ONE_ITEM_PROPERTIES)));
            } else {
                NC_ITEMS.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new Item(ITEM_PROPERTIES)));
            }
            ALL_NC_ITEMS.put(name, NC_ITEMS.get(name));
        }
    }

    private static void registerShielding() {
        List<String> parts = Arrays.asList("light", "medium", "heavy", "dps");
        int i = 1;
        for (String name : parts) {
            int finalI = i;
            NC_SHIELDING.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new RadShieldingItem(ITEM_PROPERTIES, finalI)));
            i += 2;
            ALL_NC_ITEMS.put(name, NC_SHIELDING.get(name));
        }
    }

    private static void registerParts() {
        List<String> parts = Arrays.asList("actuator", "research_paper", "basic_electric_circuit", "bioplastic", "chassis", "empty_frame", "empty_sink", "motor", "plate_advanced", "plate_basic", "plate_du", "plate_elite", "plate_extreme", "servo", "sic_fiber", "steel_frame", "coil_copper", "coil_magnesium_diboride", "coil_bscco");
        for (String name : parts) {
            if (name.equals("research_paper")) {
                NC_PARTS.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new ResearchPaperItem(ONE_ITEM_PROPERTIES)));
            } else {
                NC_PARTS.put(name, (RegistryObject<Item>)ITEMS.register(name, () -> new Item(ITEM_PROPERTIES)));
            }
            ALL_NC_ITEMS.put(name, NC_PARTS.get(name));
        }
    }

    private static void registerGems() {
        for (String name : Gems.get().registered().keySet()) {
            GEMS_TAG.put(name, (TagKey<Item>)TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "gems/" + name)));
            NC_GEMS.put(name, (RegistryObject<Item>)ITEMS.register(name + "_gem", () -> new Item(ITEM_PROPERTIES)));
            ALL_NC_ITEMS.put(name + "_gem", NC_GEMS.get(name));
        }
    }

    private static void registerChunks() {
        for (String name : Chunks.get().registered().keySet()) {
            CHUNKS_TAG.put(name, (TagKey<Item>)TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "raw_materials/" + name)));
            NC_CHUNKS.put(name, (RegistryObject<Item>)ITEMS.register(name + "_chunk", () -> new Item(ITEM_PROPERTIES)));
            ALL_NC_ITEMS.put(name + "_chunk", NC_CHUNKS.get(name));
        }
    }

    private static void registerNuggets() {
        for (String name : Nuggets.get().registered().keySet()) {
            NUGGETS_TAG.put(name, (TagKey<Item>)TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "nuggets/" + name)));
            NC_NUGGETS.put(name, (RegistryObject<Item>)ITEMS.register(name + "_nugget", () -> new Item(ITEM_PROPERTIES)));
            ALL_NC_ITEMS.put(name + "_nugget", NC_NUGGETS.get(name));
        }
    }

    private static void registerIngots() {
        for (String name : Ingots.get().registered().keySet()) {
            INGOTS_TAG.put(name, (TagKey<Item>)TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "ingots/" + name)));
            NC_INGOTS.put(name, (RegistryObject<Item>)ITEMS.register(name + "_ingot", () -> new Item(ITEM_PROPERTIES)));
            ALL_NC_ITEMS.put(name + "_ingot", NC_INGOTS.get(name));
        }
    }

    private static void registerPlates() {
        for (String name : Plates.get().registered().keySet()) {
            PLATES_TAG.put(name, (TagKey<Item>)TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "plates/" + name)));
            NC_PLATES.put(name, (RegistryObject<Item>)ITEMS.register(name + "_plate", () -> new Item(ITEM_PROPERTIES)));
            ALL_NC_ITEMS.put(name + "_plate", NC_PLATES.get(name));
        }
    }

    private static void registerDusts() {
        for (String name : Dusts.get().registered().keySet()) {
            DUSTS_TAG.put(name, (TagKey<Item>)TagKey.m_203882_(NCBlocks.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "dusts/" + name)));
            NC_DUSTS.put(name, (RegistryObject<Item>)ITEMS.register(name + "_dust", () -> new Item(ITEM_PROPERTIES)));
            ALL_NC_ITEMS.put(name + "_dust", NC_DUSTS.get(name));
        }
    }
}

