/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.world.ore.NCOre;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class NCConfiguredFeatures {
    public static final HashMap<String, ResourceKey<ConfiguredFeature<?, ?>>> ORE_CONFIGURED_FEATURES = NCConfiguredFeatures.initFeatures();

    private static HashMap<String, ResourceKey<ConfiguredFeature<?, ?>>> initFeatures() {
        HashMap features = new HashMap();
        for (String name : Ores.all().keySet()) {
            features.put(name, NCConfiguredFeatures.registerKey(name + "_ore"));
        }
        return features;
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.f_144267_);
        BlockMatchTest netherrackReplacables = new BlockMatchTest(Blocks.f_50134_);
        BlockMatchTest endReplaceables = new BlockMatchTest(Blocks.f_50259_);
        for (String name : Ores.all().keySet()) {
            NCOre ore = Ores.all().get(name);
            if (ore.dimensions.contains(0)) {
                ArrayList<OreConfiguration.TargetBlockState> overworld = new ArrayList<OreConfiguration.TargetBlockState>();
                if (ore.height[1] > 0) {
                    overworld.add(OreConfiguration.m_161021_((RuleTest)stoneReplaceable, (BlockState)Ores.all().get(name).block().m_49966_()));
                }
                if (ore.height[0] < 0) {
                    overworld.add(OreConfiguration.m_161021_((RuleTest)deepslateReplaceables, (BlockState)ore.block("_deepslate").m_49966_()));
                }
                NCConfiguredFeatures.register(context, ORE_CONFIGURED_FEATURES.get(name), Feature.f_65731_, new OreConfiguration(overworld, 9));
            }
            if (ore.dimensions.contains(-1)) {
                NCConfiguredFeatures.register(context, ORE_CONFIGURED_FEATURES.get(name), Feature.f_65731_, new OreConfiguration((RuleTest)netherrackReplacables, ore.block().m_49966_(), 9));
            }
            if (!ore.dimensions.contains(1)) continue;
            NCConfiguredFeatures.register(context, ORE_CONFIGURED_FEATURES.get(name), Feature.f_65731_, new OreConfiguration((RuleTest)endReplaceables, ore.block().m_49966_(), 9));
        }
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)NuclearCraft.rl(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

