/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.ore;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.handler.config.MaterialsConfig;
import igentuman.nc.setup.registration.NCBlocks;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.block.Block;

public class NCOre {
    public boolean initialized = false;
    public String name;
    public int color;
    public List<Integer> dimensions;
    public int veinSize;
    public int veinAmount;
    public boolean registered = true;
    public int[] height;

    private NCOre(String name) {
        this.name = name;
    }

    public NCOre vein(int size, int amount) {
        this.veinSize = size;
        this.veinAmount = amount;
        return this;
    }

    public NCOre height(int min, int max) {
        this.height = new int[]{min, max};
        return this;
    }

    public static NCOre get(String name) {
        return new NCOre(name);
    }

    public NCOre dim(Integer ... dim) {
        this.dimensions = List.of(dim);
        return this;
    }

    public NCOre config() {
        if (!this.initialized) {
            try {
                int id = Ores.all().keySet().stream().toList().indexOf(this.name);
                this.registered = (Boolean)MaterialsConfig.ORE_CONFIG.ORES.get(this.name).get(0).get();
                this.dimensions = Arrays.asList((Integer[])MaterialsConfig.ORE_CONFIG.ORES.get(this.name).get(1).get());
                this.height[0] = (Integer)MaterialsConfig.ORE_CONFIG.ORES.get(this.name).get(2).get();
                this.height[1] = (Integer)MaterialsConfig.ORE_CONFIG.ORES.get(this.name).get(3).get();
                this.initialized = true;
            }
            catch (Exception e) {
                NuclearCraft.LOGGER.error("Error while loading ore config for " + this.name + "!");
            }
        }
        return this;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public Block block(String suffix) {
        return (Block)NCBlocks.ORE_BLOCKS.get(this.name + suffix).get();
    }

    public Block block() {
        return (Block)NCBlocks.ORE_BLOCKS.get(this.name).get();
    }
}

