/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexexcrafting.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.item.PackageItem;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.recipe.PositionedProcessingPackageRecipeType;

public class EpicPackageRecipeHelper {
    public static final EpicPackageRecipeHelper INSTANCE = new EpicPackageRecipeHelper();

    private EpicPackageRecipeHelper() {
    }

    public Int2ObjectMap<ItemStack> encoderToMatrix(List<ItemStack> input) {
        int i;
        Int2ObjectOpenHashMap matrix = new Int2ObjectOpenHashMap();
        for (int i2 = 0; i2 < 81; ++i2) {
            input.get(i2).m_41764_(1);
        }
        List<ItemStack> cornerNW = this.itemToCorner(input.get(0), 3);
        matrix.put(0, (Object)cornerNW.get(0));
        matrix.put(1, (Object)cornerNW.get(1));
        matrix.put(11, (Object)cornerNW.get(2));
        matrix.put(12, (Object)cornerNW.get(3));
        List<ItemStack> cornerNE = this.itemToCorner(input.get(8), 2);
        matrix.put(9, (Object)cornerNE.get(0));
        matrix.put(10, (Object)cornerNE.get(1));
        matrix.put(20, (Object)cornerNE.get(2));
        matrix.put(21, (Object)cornerNE.get(3));
        List<ItemStack> cornerSW = this.itemToCorner(input.get(72), 1);
        matrix.put(99, (Object)cornerSW.get(0));
        matrix.put(100, (Object)cornerSW.get(1));
        matrix.put(110, (Object)cornerSW.get(2));
        matrix.put(111, (Object)cornerSW.get(3));
        List<ItemStack> cornerSE = this.itemToCorner(input.get(80), 0);
        matrix.put(108, (Object)cornerSE.get(0));
        matrix.put(109, (Object)cornerSE.get(1));
        matrix.put(119, (Object)cornerSE.get(2));
        matrix.put(120, (Object)cornerSE.get(3));
        for (i = 1; i < 8; ++i) {
            List<ItemStack> sideN = this.itemToVertical(input.get(i), 1);
            matrix.put(1 + i, (Object)sideN.get(0));
            matrix.put(12 + i, (Object)sideN.get(1));
        }
        for (i = 1; i < 8; ++i) {
            List<ItemStack> sideS = this.itemToVertical(input.get(72 + i), 0);
            matrix.put(100 + i, (Object)sideS.get(0));
            matrix.put(111 + i, (Object)sideS.get(1));
        }
        for (i = 1; i < 8; ++i) {
            List<ItemStack> sideW = this.itemToHorizontal(input.get(i * 9), 1);
            matrix.put(11 + i * 11, (Object)sideW.get(0));
            matrix.put(12 + i * 11, (Object)sideW.get(1));
        }
        for (i = 1; i < 8; ++i) {
            List<ItemStack> sideE = this.itemToHorizontal(input.get(8 + i * 9), 0);
            matrix.put(20 + i * 11, (Object)sideE.get(0));
            matrix.put(21 + i * 11, (Object)sideE.get(1));
        }
        for (i = 1; i < 8; ++i) {
            for (int j = 1; j < 8; ++j) {
                matrix.put(12 + i * 11 + j, (Object)input.get(i * 9 + j).m_41777_());
            }
        }
        for (i = 0; i < 121; ++i) {
            if (!((ItemStack)matrix.get(i)).m_41619_()) continue;
            matrix.remove(i);
        }
        return matrix;
    }

    public Int2ObjectMap<ItemStack> matrixToEncoder(Int2ObjectMap<ItemStack> matrix, boolean shapeless) {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        if (shapeless && matrix.size() <= 81) {
            int i2;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (i2 = 0; i2 < 121; ++i2) {
                ItemStack stack = (ItemStack)matrix.getOrDefault(i2, (Object)ItemStack.f_41583_);
                if (stack.m_41619_()) continue;
                list.add(stack);
            }
            for (i2 = 0; i2 < list.size(); ++i2) {
                map.put(i2, (Object)((ItemStack)list.get(i2)));
            }
            return map;
        }
        ItemStack cornerNW = this.cornerToItem((ItemStack)matrix.getOrDefault(0, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(1, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(11, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(12, (Object)ItemStack.f_41583_), 3);
        map.put(0, (Object)cornerNW);
        ItemStack cornerNE = this.cornerToItem((ItemStack)matrix.getOrDefault(9, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(10, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(20, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(21, (Object)ItemStack.f_41583_), 2);
        map.put(8, (Object)cornerNE);
        ItemStack cornerSW = this.cornerToItem((ItemStack)matrix.getOrDefault(99, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(100, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(110, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(111, (Object)ItemStack.f_41583_), 1);
        map.put(72, (Object)cornerSW);
        ItemStack cornerSE = this.cornerToItem((ItemStack)matrix.getOrDefault(108, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(109, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(119, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(120, (Object)ItemStack.f_41583_), 0);
        map.put(80, (Object)cornerSE);
        for (i = 1; i < 8; ++i) {
            ItemStack sideN = this.verticalToItem((ItemStack)matrix.getOrDefault(1 + i, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(12 + i, (Object)ItemStack.f_41583_), 1);
            map.put(i, (Object)sideN);
        }
        for (i = 1; i < 8; ++i) {
            ItemStack sideS = this.verticalToItem((ItemStack)matrix.getOrDefault(100 + i, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(111 + i, (Object)ItemStack.f_41583_), 0);
            map.put(72 + i, (Object)sideS);
        }
        for (i = 1; i < 8; ++i) {
            ItemStack sideW = this.horizontalToItem((ItemStack)matrix.getOrDefault(11 + i * 11, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(12 + i * 11, (Object)ItemStack.f_41583_), 1);
            map.put(i * 9, (Object)sideW);
        }
        for (i = 1; i < 8; ++i) {
            ItemStack sideE = this.horizontalToItem((ItemStack)matrix.getOrDefault(20 + i * 11, (Object)ItemStack.f_41583_), (ItemStack)matrix.getOrDefault(21 + i * 11, (Object)ItemStack.f_41583_), 0);
            map.put(8 + i * 9, (Object)sideE);
        }
        for (i = 1; i < 8; ++i) {
            for (int j = 1; j < 8; ++j) {
                map.put(i * 9 + j, (Object)((ItemStack)matrix.getOrDefault(12 + i * 11 + j, (Object)ItemStack.f_41583_)).m_41777_());
            }
        }
        for (i = 0; i < 81; ++i) {
            if (!((ItemStack)map.get(i)).m_41619_()) continue;
            map.remove(i);
        }
        return map;
    }

    public List<ItemStack> itemToCorner(ItemStack input, int corner) {
        IPackageItem packageItem;
        IPackageRecipeInfo recipe;
        NonNullList list = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        if (input.m_41619_()) {
            return list;
        }
        Item item = input.m_41720_();
        if (item instanceof IPackageItem && (recipe = (packageItem = (IPackageItem)item).getRecipeInfo(input)) instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo positionedRecipe = (IPositionedProcessingPackageRecipeInfo)recipe;
            Int2ObjectMap matrix = positionedRecipe.getMatrix();
            list.set(0, ((ItemStack)matrix.getOrDefault(30, (Object)ItemStack.f_41583_)).m_41777_());
            list.set(1, ((ItemStack)matrix.getOrDefault(32, (Object)ItemStack.f_41583_)).m_41777_());
            list.set(2, ((ItemStack)matrix.getOrDefault(48, (Object)ItemStack.f_41583_)).m_41777_());
            list.set(3, ((ItemStack)matrix.getOrDefault(50, (Object)ItemStack.f_41583_)).m_41777_());
            for (ItemStack stack : list) {
                stack.m_41764_(1);
            }
            return list;
        }
        list.set(corner, input);
        return list;
    }

    public ItemStack cornerToItem(ItemStack input0, ItemStack input1, ItemStack input2, ItemStack input3, int corner) {
        IPackageItem packageItem;
        ItemStack stack;
        Item item;
        List<ItemStack> inputs = List.of(input0, input1, input2, input3);
        long nonEmptyCount = inputs.stream().filter(s -> !s.m_41619_()).count();
        if (nonEmptyCount == 0L) {
            return ItemStack.f_41583_;
        }
        if (!(nonEmptyCount != 1L || inputs.get(corner).m_41619_() || (item = (stack = inputs.get(corner)).m_41720_()) instanceof IPackageItem && (packageItem = (IPackageItem)item).getRecipeInfo(stack) instanceof IPositionedProcessingPackageRecipeInfo)) {
            return stack;
        }
        NonNullList list = NonNullList.m_122780_((int)81, (Object)ItemStack.f_41583_);
        list.set(30, input0);
        list.set(32, input1);
        list.set(48, input2);
        list.set(50, input3);
        IPackageRecipeInfo recipe = PositionedProcessingPackageRecipeType.INSTANCE.getNewRecipeInfo();
        recipe.generateFromStacks((List)list, List.of(), null);
        return PackageItem.makePackage((IPackageRecipeInfo)recipe, (int)0);
    }

    public List<ItemStack> itemToVertical(ItemStack input, int side) {
        IPackageItem packageItem;
        IPackageRecipeInfo recipe;
        NonNullList list = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        if (input.m_41619_()) {
            return list;
        }
        Item item = input.m_41720_();
        if (item instanceof IPackageItem && (recipe = (packageItem = (IPackageItem)item).getRecipeInfo(input)) instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo positionedRecipe = (IPositionedProcessingPackageRecipeInfo)recipe;
            Int2ObjectMap matrix = positionedRecipe.getMatrix();
            list.set(0, ((ItemStack)matrix.getOrDefault(31, (Object)ItemStack.f_41583_)).m_41777_());
            list.set(1, ((ItemStack)matrix.getOrDefault(49, (Object)ItemStack.f_41583_)).m_41777_());
            for (ItemStack stack : list) {
                stack.m_41764_(1);
            }
            return list;
        }
        list.set(side, input);
        return list;
    }

    public ItemStack verticalToItem(ItemStack input0, ItemStack input1, int side) {
        IPackageItem packageItem;
        ItemStack stack;
        Item item;
        List<ItemStack> inputs = List.of(input0, input1);
        long nonEmptyCount = inputs.stream().filter(s -> !s.m_41619_()).count();
        if (nonEmptyCount == 0L) {
            return ItemStack.f_41583_;
        }
        if (!(nonEmptyCount != 1L || inputs.get(side).m_41619_() || (item = (stack = inputs.get(side)).m_41720_()) instanceof IPackageItem && (packageItem = (IPackageItem)item).getRecipeInfo(stack) instanceof IPositionedProcessingPackageRecipeInfo)) {
            return stack;
        }
        NonNullList list = NonNullList.m_122780_((int)81, (Object)ItemStack.f_41583_);
        list.set(31, input0);
        list.set(49, input1);
        IPackageRecipeInfo recipe = PositionedProcessingPackageRecipeType.INSTANCE.getNewRecipeInfo();
        recipe.generateFromStacks((List)list, List.of(), null);
        return PackageItem.makePackage((IPackageRecipeInfo)recipe, (int)0);
    }

    public List<ItemStack> itemToHorizontal(ItemStack input, int side) {
        IPackageItem packageItem;
        IPackageRecipeInfo recipe;
        NonNullList list = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        if (input.m_41619_()) {
            return list;
        }
        Item item = input.m_41720_();
        if (item instanceof IPackageItem && (recipe = (packageItem = (IPackageItem)item).getRecipeInfo(input)) instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo positionedRecipe = (IPositionedProcessingPackageRecipeInfo)recipe;
            Int2ObjectMap matrix = positionedRecipe.getMatrix();
            list.set(0, ((ItemStack)matrix.getOrDefault(39, (Object)ItemStack.f_41583_)).m_41777_());
            list.set(1, ((ItemStack)matrix.getOrDefault(41, (Object)ItemStack.f_41583_)).m_41777_());
            for (ItemStack stack : list) {
                stack.m_41764_(1);
            }
            return list;
        }
        list.set(side, input);
        return list;
    }

    public ItemStack horizontalToItem(ItemStack input0, ItemStack input1, int side) {
        IPackageItem packageItem;
        ItemStack stack;
        Item item;
        List<ItemStack> inputs = List.of(input0, input1);
        long nonEmptyCount = inputs.stream().filter(s -> !s.m_41619_()).count();
        if (nonEmptyCount == 0L) {
            return ItemStack.f_41583_;
        }
        if (!(nonEmptyCount != 1L || inputs.get(side).m_41619_() || (item = (stack = inputs.get(side)).m_41720_()) instanceof IPackageItem && (packageItem = (IPackageItem)item).getRecipeInfo(stack) instanceof IPositionedProcessingPackageRecipeInfo)) {
            return stack;
        }
        NonNullList list = NonNullList.m_122780_((int)81, (Object)ItemStack.f_41583_);
        list.set(39, input0);
        list.set(41, input1);
        IPackageRecipeInfo recipe = PositionedProcessingPackageRecipeType.INSTANCE.getNewRecipeInfo();
        recipe.generateFromStacks((List)list, List.of(), null);
        return PackageItem.makePackage((IPackageRecipeInfo)recipe, (int)0);
    }
}

