/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v2;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.PlayerCapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.PlayerRespawnCopyStrategy;
import fuzs.puzzleslib.api.capability.v2.data.SyncStrategy;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.ApiStatus;

public interface CapabilityController {
    @ApiStatus.Internal
    public static final Map<ResourceLocation, CapabilityKey<?>> CAPABILITY_KEY_REGISTRY = Maps.newConcurrentMap();
    @ApiStatus.Internal
    public static final Set<Class<?>> VALID_CAPABILITY_TYPES = Set.of(Entity.class, BlockEntity.class, LevelChunk.class, Level.class);

    @ApiStatus.Internal
    public static <T extends CapabilityComponent> void submit(CapabilityKey<T> capabilityKey) {
        if (CAPABILITY_KEY_REGISTRY.put(capabilityKey.getId(), capabilityKey) != null) {
            throw new IllegalStateException("Duplicate capability %s".formatted(capabilityKey.getId()));
        }
    }

    @ApiStatus.Internal
    public static CapabilityKey<?> retrieve(ResourceLocation id) {
        CapabilityKey<?> capabilityKey = CAPABILITY_KEY_REGISTRY.get(id);
        if (capabilityKey != null) {
            return capabilityKey;
        }
        throw new IllegalStateException("No capability registered for id %s".formatted(id));
    }

    public static CapabilityController from(String modId) {
        return ModContext.get(modId).getCapabilityController();
    }

    public <T extends Entity, C extends CapabilityComponent> CapabilityKey<C> registerEntityCapability(String var1, Class<C> var2, Function<T, C> var3, Class<T> var4);

    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String var1, Class<C> var2, Function<Player, C> var3, PlayerRespawnCopyStrategy var4);

    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String var1, Class<C> var2, Function<Player, C> var3, PlayerRespawnCopyStrategy var4, SyncStrategy var5);

    public <T extends BlockEntity, C extends CapabilityComponent> CapabilityKey<C> registerBlockEntityCapability(String var1, Class<C> var2, Function<T, C> var3, Class<T> var4);

    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelChunkCapability(String var1, Class<C> var2, Function<ChunkAccess, C> var3);

    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelCapability(String var1, Class<C> var2, Function<Level, C> var3);
}

