/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.client.adapter.ResourcePackAdapter;
import org.zeith.hammerlib.compat.base.CompatList;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.solarflux.RecipesSF;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.client.SolarFluxResourcePack;
import org.zeith.solarflux.client.SolarPanelBakedModel;
import org.zeith.solarflux.compat._base.SFCompatList;
import org.zeith.solarflux.compat._base.SolarFluxCompat;
import org.zeith.solarflux.init.ItemsSF;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.net.PacketSyncPanelData;
import org.zeith.solarflux.proxy.SFRClientProxy;
import org.zeith.solarflux.proxy.SFRCommonProxy;

@Mod(value="solarflux")
public class SolarFlux {
    public static final String MOD_ID = "solarflux";
    public static final Logger LOG = LogManager.getLogger();
    public static final SFRCommonProxy PROXY = (SFRCommonProxy)DistExecutor.unsafeRunForDist(() -> SFRClientProxy::new, () -> SFRCommonProxy::new);
    @CreativeTab.RegisterTab
    public static final CreativeTab ITEM_GROUP = new CreativeTab(new ResourceLocation("solarflux", "root"), b -> b.m_257737_(() -> ((Item)ItemsSF.PHOTOVOLTAIC_CELL_3).m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.solarflux")).withTabsBefore(new ResourceLocation[]{HLConstants.HL_TAB.id()}));
    public static final SFCompatList SF_COMPAT = (SFCompatList)CompatList.gather(SolarFluxCompat.class, SFCompatList::new);

    public SolarFlux() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modBus.addListener(RecipesSF::addRecipes);
        SolarPanelsSF.init();
        SF_COMPAT.setupSolarPanels();
        LanguageAdapter.registerMod((String)MOD_ID);
        ResourcePackAdapter.registerResourcePack((PackResources)SolarFluxResourcePack.getPackInstance());
        CommonMessages.printMessageOnIllegalRedistribution(SolarFlux.class, (Logger)LOG, (String)"Solar Flux Reborn", (String)"https://www.curseforge.com/minecraft/mc-mods/solar-flux-reborn");
    }

    public static ResourceLocation id(String s) {
        return new ResourceLocation(MOD_ID, s);
    }

    @SubscribeEvent
    public void startServer(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)MOD_ID).then(Commands.m_82127_((String)"reload").executes(src -> {
            SolarPanelsSF.refreshConfigs();
            ((CommandSourceStack)src.getSource()).m_81377_().m_6846_().m_11314_().forEach(PacketSyncPanelData::sendAllPanels);
            return 1;
        })));
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            LOG.info("Sending solar panels to " + sp.m_36316_().getName() + ".");
            PacketSyncPanelData.sendAllPanels(sp);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent e) {
            PROXY.commonSetup();
        }

        @SubscribeEvent
        public static void loadComplete(FMLLoadCompleteEvent e) {
            SolarPanelsSF.refreshConfigs();
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void clientSetup(FMLClientSetupEvent e) {
            PROXY.clientSetup();
        }

        @SubscribeEvent
        public static void fingerprintCheck(FMLFingerprintCheckEvent e) {
            CommonMessages.printMessageOnFingerprintViolation((FMLFingerprintCheckEvent)e, (String)"97e852e9b3f01b83574e8315f7e77651c6605f2b455919a7319e9869564f013c", (Logger)LOG, (String)"Solar Flux Reborn", (String)"https://www.curseforge.com/minecraft/mc-mods/solar-flux-reborn");
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void modelBake(ModelEvent.ModifyBakingResult e) {
            SolarPanelsSF.listPanelBlocks().forEach(spb -> e.getModels().put(new ModelResourceLocation(spb.getRegistryName(), ""), new SolarPanelBakedModel((SolarPanelBlock)((Object)spb))));
        }
    }
}

