/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.tiles.tooltip.EnumNumberFormat;
import org.zeith.hammerlib.tiles.tooltip.EnumTooltipEngine;
import org.zeith.hammerlib.tiles.tooltip.ITooltipConsumer;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.hammerlib.util.mcf.NormalizedTicker;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.attribute.SimpleAttributeProperty;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.compat._abilities.SFAbilities;
import org.zeith.solarflux.container.SolarPanelContainer;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.init.TilesSF;
import org.zeith.solarflux.items.upgrades._base.ISunIntensityMod;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.items.upgrades._base.UpgradeSystem;
import org.zeith.solarflux.net.PacketRequestSolarIntensity;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanelInstance;
import org.zeith.solarflux.util.BlockPosFace;

public class SolarPanelTile
extends TileSyncableTickable
implements IEnergyStorage,
IContainerTile,
ISolarPanelTile,
ITooltipTile {
    public long energy;
    public long currentGeneration;
    public float sunIntensity = 1.0E-30f;
    private SolarPanel delegate;
    private SolarPanelInstance instance;
    public final SimpleInventory upgradeInventory = new SimpleInventory(5);
    public final SimpleInventory chargeInventory = new SimpleInventory(1);
    public final List<BlockPosFace> traversal = new ArrayList<BlockPosFace>();
    public final SimpleAttributeProperty generation = new SimpleAttributeProperty();
    public final SimpleAttributeProperty transfer = new SimpleAttributeProperty();
    public final SimpleAttributeProperty capacity = new SimpleAttributeProperty();
    protected int refreshTimer = 0;
    List<ResourceLocation> tickedUpgrades = new ArrayList<ResourceLocation>();
    private static final Direction[] DIRECTIONS_NO_UP = (Direction[])Direction.m_235666_().filter(f -> f != Direction.UP).toArray(Direction[]::new);
    private static final Direction[] DIRECTIONS_HORIZONTAL = (Direction[])Direction.m_235666_().filter(f -> f.m_122434_() != Direction.Axis.Y).toArray(Direction[]::new);
    protected final NormalizedTicker ticker = NormalizedTicker.create(this::normTick);
    int effCacheTime;
    float effCache;
    public boolean cache$seeSky;
    public byte cache$seeSkyTimer;
    public static final ModelProperty<Level> WORLD_PROP = new ModelProperty();
    public static final ModelProperty<BlockPos> POS_PROP = new ModelProperty();
    LazyOptional<IItemHandler> chargeableItems = LazyOptional.of(() -> this.chargeInventory);
    LazyOptional<IEnergyStorage> energyStorageTile = LazyOptional.of(() -> this);
    int voxelTimer = 0;
    VoxelShape shape;

    public SolarPanelTile(BlockPos pos, BlockState state) {
        super(TilesSF.SOLAR_PANEL, pos, state);
        this.onConstructed();
    }

    protected void onConstructed() {
    }

    public void m_7651_() {
        super.m_7651_();
        this.setRemovedSFR();
    }

    public void setRemovedSFR() {
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onChunkUnloadedSFR();
    }

    public void onChunkUnloadedSFR() {
    }

    public void m_6339_() {
        super.m_6339_();
        this.clearRemovedSFR();
    }

    public void clearRemovedSFR() {
    }

    @Override
    public int getUpgrades(Item type) {
        int c = 0;
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            ItemStack stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != type) continue;
            c += stack.m_41613_();
        }
        return c;
    }

    @Override
    public Stream<Tuple2<UpgradeItem, ItemStack>> getUpgrades() {
        return this.upgradeInventory.stream().map(i -> {
            Tuple2 tuple2;
            Item patt4456$temp;
            if (!i.m_41619_() && (patt4456$temp = i.m_41720_()) instanceof UpgradeItem) {
                UpgradeItem u = (UpgradeItem)patt4456$temp;
                tuple2 = Tuples.immutable((Object)((Object)u), (Object)i);
            } else {
                tuple2 = null;
            }
            return tuple2;
        }).filter(Objects::nonNull);
    }

    @Override
    public SolarPanel getDelegate() {
        if (this.delegate == null) {
            Block blk = this.m_58900_().m_60734_();
            this.delegate = blk instanceof SolarPanelBlock ? ((SolarPanelBlock)blk).panel : SolarPanelsSF.CORE_PANELS[0];
        }
        return this.delegate;
    }

    @Override
    public SolarPanelInstance getInstance() {
        if (this.instance == null || this.instance.getDelegate() != this.getDelegate()) {
            this.instance = this.getDelegate().createInstance(this);
        }
        return this.instance;
    }

    public void tickUpgrades() {
        ItemStack stack;
        int i;
        this.generation.clearAttributes();
        this.transfer.clearAttributes();
        this.capacity.clearAttributes();
        for (i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            UpgradeItem upgrade;
            stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof UpgradeItem && (upgrade = (UpgradeItem)item).canStayInPanel(this, stack, this.upgradeInventory)) {
                ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                if (this.tickedUpgrades.contains(id)) continue;
                upgrade.update(this, stack, this.getUpgrades(upgrade));
                this.tickedUpgrades.add(id);
                continue;
            }
            ItemStack s = this.upgradeInventory.getStackInSlot(i);
            s.m_41777_();
            this.upgradeInventory.setStackInSlot(i, ItemStack.f_41583_);
            if (!this.isOnServer()) continue;
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack));
        }
        if (this.energy > 0L && this.getInstance() != null) {
            for (i = 0; i < this.chargeInventory.getSlots(); ++i) {
                stack = this.chargeInventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                stack.getCapability(ForgeCapabilities.ENERGY).filter(e -> e.getEnergyStored() < e.getMaxEnergyStored()).ifPresent(e -> {
                    this.transfer.setBaseValue(this.getInstance().transfer);
                    int transfer = this.transfer.getValueI();
                    this.energy -= (long)e.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
                });
            }
        }
        this.tickedUpgrades.clear();
    }

    public void update() {
        this.ticker.tick(this.f_58857_);
    }

    public boolean atTickRate(int rate) {
        return this.ticker.atTickRate(rate);
    }

    public void normTick(int suppressed) {
        BlockEntity tile;
        Block blk;
        if (this.voxelTimer > 0) {
            --this.voxelTimer;
        }
        if (!((blk = this.m_58900_().m_60734_()) instanceof SolarPanelBlock)) {
            return;
        }
        SolarPanelBlock spb = (SolarPanelBlock)blk;
        this.delegate = spb.panel;
        if (this.cache$seeSkyTimer > 0) {
            this.cache$seeSkyTimer = (byte)(this.cache$seeSkyTimer - 1);
        }
        if (this.refreshTimer > 0) {
            --this.refreshTimer;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            this.traversal.clear();
        }
        this.tickUpgrades();
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI() * suppressed;
        long gen = this.getGeneration();
        this.capacity.setBaseValue(this.getInstance().cap);
        this.energy += Math.min(this.capacity.getValueL() - this.energy, gen * (long)suppressed);
        this.currentGeneration = gen;
        this.energy = SolarPanelTile.clamp(this.energy, 0L, this.capacity.getValueL());
        for (Direction hor : DIRECTIONS_HORIZONTAL) {
            tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(hor));
            if (!(tile instanceof SolarPanelTile)) continue;
            SolarPanelTile spt = (SolarPanelTile)tile;
            this.autoBalanceEnergy(spt);
        }
        for (Direction hor : DIRECTIONS_NO_UP) {
            tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(hor));
            if (tile == null) continue;
            tile.getCapability(ForgeCapabilities.ENERGY, hor.m_122424_()).ifPresent(storage -> {
                if (storage.canReceive()) {
                    this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
                }
            });
        }
        if (!this.traversal.isEmpty() && this.energy > 0L) {
            for (BlockPosFace traverse : this.traversal) {
                BlockEntity tile2 = this.f_58857_.m_7702_(traverse.pos);
                if (tile2 == null) continue;
                tile2.getCapability(ForgeCapabilities.ENERGY, traverse.face).ifPresent(storage -> {
                    if (storage.canReceive()) {
                        this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), Math.round((float)transfer * traverse.rate)), false);
                    }
                });
                if (this.energy >= 1L) continue;
                break;
            }
        }
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        if (this.effCacheTime > 0) {
            --this.effCacheTime;
        }
    }

    @Override
    public int getGeneration() {
        float eff = this.effCache;
        if (this.effCacheTime <= 0) {
            eff = this.getInstance().computeSunIntensity(this);
            for (ISunIntensityMod mod : UpgradeSystem.findAbilitiesIn(this, SFAbilities.ITEM_UPGRADE_SUN_INTENSITY_MUL)) {
                eff = mod.applySunIntensityModifier(this, eff);
            }
            float raining = this.f_58857_.m_46722_(1.0f);
            raining = raining > 0.2f ? (raining - 0.2f) / 0.8f : 0.0f;
            raining = (float)Math.sin((double)raining * Math.PI / 2.0);
            eff *= 1.0f - raining * (1.0f - SolarPanelsSF.RAIN_MULTIPLIER);
            float thundering = this.f_58857_.m_46661_(1.0f);
            thundering = thundering > 0.75f ? (thundering - 0.75f) / 0.25f : 0.0f;
            thundering = (float)Math.sin((double)thundering * Math.PI / 2.0);
            this.effCache = eff *= 1.0f - thundering * (1.0f - SolarPanelsSF.THUNDER_MULTIPLIER);
            this.effCacheTime = 5;
        }
        if (!this.f_58857_.f_46443_) {
            this.sunIntensity = eff;
        }
        float gen = (float)this.getInstance().gen * eff;
        this.generation.setBaseValue(gen);
        return this.generation.getValueI();
    }

    public int autoBalanceEnergy(SolarPanelTile solar) {
        int delta = this.getEnergyStored() - solar.getEnergyStored();
        if (delta < 0) {
            return solar.autoBalanceEnergy(this);
        }
        if (delta > 0) {
            return this.extractEnergy(solar.receiveEnergyInternal(this.extractEnergy(solar.receiveEnergyInternal(delta / 2, true), true), false), false);
        }
        return 0;
    }

    @Override
    public boolean doesSeeSky() {
        if (this.cache$seeSkyTimer < 1) {
            this.cache$seeSkyTimer = (byte)20;
            this.cache$seeSky = this.f_58857_ != null && this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) > 0 && this.f_58857_.m_45527_(this.f_58858_.m_7494_());
        }
        return this.cache$seeSky;
    }

    @Override
    public Level level() {
        return this.f_58857_;
    }

    @Override
    public BlockPos pos() {
        return this.f_58858_;
    }

    @Override
    public List<BlockPosFace> traversal() {
        return this.traversal;
    }

    @Override
    public long energy() {
        return this.energy;
    }

    @Override
    public void energy(long newEnergy) {
        this.energy = SolarPanelTile.clamp(newEnergy, 0L, this.capacity.getValueL());
    }

    @Override
    public SimpleAttributeProperty generation() {
        return this.generation;
    }

    @Override
    public SimpleAttributeProperty transfer() {
        return this.transfer;
    }

    @Override
    public SimpleAttributeProperty capacity() {
        return this.capacity;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(WORLD_PROP, (Object)this.f_58857_).with(POS_PROP, (Object)this.f_58858_).build();
    }

    public CompoundTag writeNBT(CompoundTag nbt) {
        this.upgradeInventory.writeToNBT(nbt, "Upgrades");
        this.chargeInventory.writeToNBT(nbt, "Chargeable");
        nbt.m_128356_("Energy", this.energy);
        return nbt;
    }

    public void readNBT(CompoundTag nbt) {
        this.upgradeInventory.readFromNBT(nbt, "Upgrades");
        this.chargeInventory.readFromNBT(nbt, "Chargeable");
        this.energy = nbt.m_128454_("Energy");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.chargeableItems.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyStorageTile.cast();
        }
        return super.getCapability(cap, side);
    }

    public void resetVoxelShape() {
        this.shape = null;
    }

    public VoxelShape getShape(SolarPanelBlock block) {
        if (this.shape == null || this.voxelTimer <= 0) {
            this.shape = block.recalcShape((BlockGetter)this.f_58857_, this.f_58858_);
            this.voxelTimer = 20;
        }
        return this.shape;
    }

    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return new SolarPanelContainer(windowId, player.m_150109_(), this);
    }

    @Nullable
    public Component getDisplayName() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(transfer, maxExtract));
        if (!simulate) {
            this.energy -= (long)energyExtracted;
        }
        return energyExtracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        this.capacity.setBaseValue(this.getInstance().cap);
        long cap = this.capacity.getValueL();
        int energyReceived = Math.min((int)Math.min(cap - this.energy, Integer.MAX_VALUE), Math.min(transfer, maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.energy, Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getInstance().cap, Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public ItemStack generateItem(ItemLike item) {
        ItemStack stack = new ItemStack(item);
        long reducedEnergy = this.energy - Math.round((double)this.energy * SolarPanelsSF.LOOSE_ENERGY / 100.0);
        if (reducedEnergy > 0L || !this.chargeInventory.m_7983_() || !this.upgradeInventory.m_7983_()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("Energy", reducedEnergy);
            this.upgradeInventory.writeToNBT(tag, "Upgrades");
            this.chargeInventory.writeToNBT(tag, "Chargeable");
            stack.m_41751_(tag);
        }
        return stack;
    }

    public void loadFromItem(ItemStack stack) {
        if (stack.m_41782_()) {
            this.energy = stack.m_41783_().m_128454_("Energy");
            this.upgradeInventory.readFromNBT(stack.m_41783_(), "Upgrades");
            this.chargeInventory.readFromNBT(stack.m_41783_(), "Chargeable");
        }
    }

    public boolean isEngineSupported(EnumTooltipEngine engine) {
        return HLConstants.enableHammerLibTooltipEngine && SolarPanelsSF.enableHammerLibTooltips || engine != EnumTooltipEngine.HAMMER_LIB;
    }

    public void addTooltip(ITooltipConsumer consumer, Player player) {
        if (this.level().m_5776_() && (this.refreshTimer <= 0 || this.sunIntensity == 1.0E-30f)) {
            this.refreshTimer = 5;
            Network.sendToServer((IPacket)new PacketRequestSolarIntensity(this.pos(), 0.0f));
            if (this.sunIntensity == 1.0E-30f) {
                return;
            }
        }
        consumer.addLine((Component)Component.m_237113_((String)Component.m_237115_((String)"info.solarflux.sun.intensity").getString().replaceFirst(":.*$", ":")));
        ProgressBar bar = new ProgressBar(100L).withStyle(ProgressBar.ProgressBarStyle.FORGE_ENERGY_STYLE).setProgress((long)Math.round(100.0f * this.sunIntensity)).withNumberFormat(EnumNumberFormat.FULL);
        bar.filledMainColor = -1984453;
        bar.filledAlternateColor = -7975160;
        bar.suffix = "%";
        consumer.addBar(bar);
    }

    public void setDelegate(SolarPanel delegate) {
        this.delegate = delegate;
    }

    public static long clamp(long val, long min, long max) {
        return Math.min(Math.max(val, min), max);
    }
}

