/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.annotation;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.ConstantColor;
import appeng.client.guidebook.color.MutableColor;
import appeng.client.guidebook.document.LytPoint;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.RenderContext;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.annotation.OverlayAnnotation;
import appeng.core.AppEng;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class DiamondAnnotation
extends OverlayAnnotation {
    private final Vector3f pos;
    private final ColorValue outerColor;
    private final ColorValue color;

    public DiamondAnnotation(Vector3f pos, ColorValue color) {
        this.pos = pos;
        this.color = color;
        this.outerColor = new ConstantColor(-3355444);
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public ColorValue getColor() {
        return this.color;
    }

    @Override
    public LytRect getBoundingRect(GuidebookScene scene, LytRect viewport) {
        Vector2f screenPos = scene.worldToScreen(this.pos.x, this.pos.y, this.pos.z);
        LytPoint docPoint = scene.screenToDocument(screenPos, viewport);
        int x = Math.round(docPoint.x());
        int y = Math.round(docPoint.y());
        return new LytRect(x - 8, y - 8, 16, 16);
    }

    @Override
    public void render(GuidebookScene scene, RenderContext context, LytRect viewport) {
        LytRect rect = this.getBoundingRect(scene, viewport);
        ColorValue outer = this.outerColor;
        ColorValue inner = this.color;
        if (this.isHovered()) {
            outer = MutableColor.of(outer).lighter(20.0f);
            inner = MutableColor.of(inner).lighter(20.0f);
        }
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(AppEng.makeId("textures/guide/diamond.png"));
        context.fillTexturedRect(rect, texture, outer, outer, outer, outer, 0.0f, 0.0f, 0.5f, 1.0f);
        context.fillTexturedRect(rect, texture, inner, inner, inner, inner, 0.5f, 0.0f, 1.0f, 1.0f);
    }
}

