/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.definitions.AEBlocks;
import appeng.recipes.handlers.InscriberRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

class InscriberRecipeCategory
implements IRecipeCategory<InscriberRecipe> {
    private static final String TITLE_TRANSLATION_KEY = "block.ae2.inscriber";
    public static final RecipeType<InscriberRecipe> RECIPE_TYPE = RecipeType.create((String)"ae2", (String)"inscriber", InscriberRecipe.class);
    private final IDrawable background;
    private final IDrawableAnimated progress;
    private final IDrawable icon;

    public InscriberRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("ae2", "textures/guis/inscriber.png");
        this.background = guiHelper.createDrawable(location, 44, 15, 97, 64);
        IDrawableStatic progressDrawable = guiHelper.drawableBuilder(location, 135, 177, 6, 18).addPadding(24, 0, 91, 0).build();
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AEBlocks.INSCRIBER.stack());
    }

    public RecipeType<InscriberRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)TITLE_TRANSLATION_KEY);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InscriberRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setSlotName("top").addIngredients(recipe.getTopOptional());
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 24).setSlotName("top").addIngredients(recipe.getMiddleInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 47).setSlotName("top").addIngredients(recipe.getBottomOptional());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 69, 25).setSlotName("output").addItemStack(recipe.getResultItem());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(InscriberRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.progress.draw(guiGraphics);
    }
}

