/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p;

import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.parts.p2p.FEP2PTunnelPart;
import appeng.parts.p2p.FluidP2PTunnelPart;
import appeng.parts.p2p.ItemP2PTunnelPart;
import appeng.parts.p2p.LightP2PTunnelPart;
import appeng.parts.p2p.MEP2PTunnelPart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.parts.p2p.RedstoneP2PTunnelPart;
import dev.lasm.betterp2p.util.p2p.TunnelInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001f\u0010\u0010J\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J7\u0010\u0016\u001a\u00020\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0002H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00188\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR*\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00188\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006 "}, d2={"Ldev/lasm/betterp2p/CommonProxy;", "", "Ljava/lang/Class;", "clazz", "Ldev/lasm/betterp2p/util/p2p/TunnelInfo;", "getP2PFromClass", "(Ljava/lang/Class;)Ldev/lasm/betterp2p/util/p2p/TunnelInfo;", "", "index", "getP2PFromIndex", "(I)Ldev/lasm/betterp2p/util/p2p/TunnelInfo;", "", "getP2PTypeList", "()Ljava/util/List;", "", "initTunnels", "()V", "Lappeng/core/definitions/ItemDefinition;", "def", "type", "Lappeng/parts/p2p/P2PTunnelPart;", "classType", "registerTunnel", "(Lappeng/core/definitions/ItemDefinition;ILjava/lang/Class;)V", "", "tunnelIndices", "Ljava/util/Map;", "getTunnelIndices", "()Ljava/util/Map;", "tunnelTypes", "getTunnelTypes", "<init>", "betterp2p"})
public class CommonProxy {
    @NotNull
    private final Map<Class<?>, TunnelInfo> tunnelTypes = new LinkedHashMap();
    @NotNull
    private final Map<Integer, TunnelInfo> tunnelIndices = new LinkedHashMap();

    @NotNull
    protected final Map<Class<?>, TunnelInfo> getTunnelTypes() {
        return this.tunnelTypes;
    }

    @NotNull
    protected final Map<Integer, TunnelInfo> getTunnelIndices() {
        return this.tunnelIndices;
    }

    public void initTunnels() {
        int typeId = 0;
        ItemDefinition itemDefinition = AEParts.ME_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition, (String)"ME_P2P_TUNNEL");
        this.registerTunnel(itemDefinition, typeId++, MEP2PTunnelPart.class);
        ItemDefinition itemDefinition2 = AEParts.FE_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition2, (String)"FE_P2P_TUNNEL");
        this.registerTunnel(itemDefinition2, typeId++, FEP2PTunnelPart.class);
        ItemDefinition itemDefinition3 = AEParts.REDSTONE_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition3, (String)"REDSTONE_P2P_TUNNEL");
        this.registerTunnel(itemDefinition3, typeId++, RedstoneP2PTunnelPart.class);
        ItemDefinition itemDefinition4 = AEParts.FLUID_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition4, (String)"FLUID_P2P_TUNNEL");
        this.registerTunnel(itemDefinition4, typeId++, FluidP2PTunnelPart.class);
        ItemDefinition itemDefinition5 = AEParts.ITEM_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition5, (String)"ITEM_P2P_TUNNEL");
        this.registerTunnel(itemDefinition5, typeId++, ItemP2PTunnelPart.class);
        ItemDefinition itemDefinition6 = AEParts.LIGHT_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition6, (String)"LIGHT_P2P_TUNNEL");
        this.registerTunnel(itemDefinition6, typeId++, LightP2PTunnelPart.class);
    }

    private final void registerTunnel(ItemDefinition<?> def, int type, Class<? extends P2PTunnelPart<?>> classType) {
        ItemStack stack = def.stack(1);
        Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
        TunnelInfo info2 = new TunnelInfo(type, stack, classType);
        this.tunnelTypes.put(classType, info2);
        Integer n = type;
        this.tunnelIndices.put(n, info2);
    }

    @Nullable
    public final TunnelInfo getP2PFromIndex(int index) {
        if (this.tunnelTypes.isEmpty()) {
            this.initTunnels();
        }
        return this.tunnelIndices.get(index);
    }

    @Nullable
    public final TunnelInfo getP2PFromClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (this.tunnelTypes.isEmpty()) {
            this.initTunnels();
        }
        return this.tunnelTypes.get(clazz);
    }

    @NotNull
    public final List<TunnelInfo> getP2PTypeList() {
        return CollectionsKt.toList((Iterable)this.tunnelIndices.values());
    }
}

