/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.item;

import appeng.api.networking.IGrid;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.parts.p2p.P2PTunnelPart;
import dev.lasm.betterp2p.client.ClientCache;
import dev.lasm.betterp2p.client.gui.widget.GuiScale;
import dev.lasm.betterp2p.item.BetterMemoryCardModes;
import dev.lasm.betterp2p.network.ModNetwork;
import dev.lasm.betterp2p.network.data.MemoryInfo;
import dev.lasm.betterp2p.network.data.P2PLocationKt;
import dev.lasm.betterp2p.util.p2p.P2PUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b \u0010!J7\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Ldev/lasm/betterp2p/item/ItemAdvancedMemoryCard;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/Level;", "level", "", "Lnet/minecraft/network/chat/Component;", "list", "Lnet/minecraft/world/item/TooltipFlag;", "tooltipFlag", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Ldev/lasm/betterp2p/network/data/MemoryInfo;", "getInfo", "(Lnet/minecraft/world/item/ItemStack;)Ldev/lasm/betterp2p/network/data/MemoryInfo;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "interactionHand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/context/UseOnContext;", "useOnContext", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "info", "writeInfo", "(Lnet/minecraft/world/item/ItemStack;Ldev/lasm/betterp2p/network/data/MemoryInfo;)V", "<init>", "()V", "betterp2p"})
public final class ItemAdvancedMemoryCard
extends Item {
    @NotNull
    public static final ItemAdvancedMemoryCard INSTANCE = new ItemAdvancedMemoryCard();

    private ItemAdvancedMemoryCard() {
        super(new Item.Properties().m_41487_(1).arch$tab(ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("ae2", "main"))));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        MemoryInfo info2 = this.getInfo(stack);
        String string = info2.getMode().name().toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        MutableComponent mutableComponent = Component.m_237115_((String)("gui.advanced_memory_card.mode." + string));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(\"gui.advanc\u2026ode.name.toLowerCase()}\")");
        list.add((Component)mutableComponent);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (player.m_6047_() && !level.f_46443_) {
            ClientCache.INSTANCE.clear();
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19090_((Object)player.m_21120_(interactionHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(player.getItemInHand(interactionHand))");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = super.m_7203_(level, player, interactionHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"super.use(level, player, interactionHand)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext useOnContext) {
        Intrinsics.checkNotNullParameter((Object)useOnContext, (String)"useOnContext");
        Level w = useOnContext.m_43725_();
        Player player = useOnContext.m_43723_();
        Intrinsics.checkNotNull((Object)player);
        Player player2 = player;
        ItemStack stack = useOnContext.m_43722_();
        BlockPos pos = useOnContext.m_8083_();
        if (w.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity te = w.m_7702_(pos);
        if (te instanceof IInWorldGridNodeHost && te instanceof IPartHost) {
            IPart part;
            IPart iPart;
            IPart iPart2 = ((IPartHost)te).selectPartWorld((Vec3)useOnContext.m_43720_()).part;
            if (iPart2 == null) {
                iPart2 = ((IPartHost)te).getPart(null);
            }
            IGrid iGrid = (iPart = (part = iPart2)) != null && (iPart = iPart.getGridNode()) != null ? iPart.getGrid() : null;
            if (iGrid == null) {
                return InteractionResult.FAIL;
            }
            IGrid grid = iGrid;
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            MemoryInfo info2 = this.getInfo(stack);
            int type = 0;
            if (part instanceof P2PTunnelPart) {
                type = P2PUtilKt.getTypeIndex((P2PTunnelPart)part);
                info2.setSelectedEntry(P2PLocationKt.toLoc((P2PTunnelPart)part));
            } else {
                type = -1;
                info2.setSelectedEntry(null);
            }
            info2.setType(type);
            this.writeInfo(stack, info2);
            ModNetwork.INSTANCE.initConnection(player2, grid, info2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public final MemoryInfo getInfo(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.m_41720_(), (Object)((Object)this))) {
            throw new ClassCastException("Cannot cast " + stack.m_41720_().getClass().getName() + " to " + ((Object)((Object)this)).getClass().getName());
        }
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128441_("gui")) {
            compound.m_128344_("gui", (byte)GuiScale.DYNAMIC.ordinal());
        }
        if (!compound.m_128425_("selectedIndex", 10)) {
            compound.m_128365_("selectedIndex", (Tag)new CompoundTag());
        }
        CompoundTag compoundTag = compound.m_128469_("selectedIndex");
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"compound.getCompound(\"selectedIndex\")");
        return new MemoryInfo(P2PLocationKt.readP2PLocation(compoundTag), compound.m_128448_("frequency"), BetterMemoryCardModes.values()[compound.m_128451_("mode")], GuiScale.values()[compound.m_128445_("gui")], 0, 16, null);
    }

    public final void writeInfo(@NotNull ItemStack stack, @NotNull MemoryInfo info2) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        if (!Intrinsics.areEqual((Object)stack.m_41720_(), (Object)((Object)this))) {
            throw new ClassCastException("Cannot cast " + stack.m_41720_().getClass().getName() + " to " + ((Object)((Object)this)).getClass().getName());
        }
        CompoundTag compound = stack.m_41784_();
        compound.m_128365_("selectedIndex", (Tag)P2PLocationKt.writeP2PLocation(info2.getSelectedEntry()));
        compound.m_128376_("frequency", info2.getFrequency());
        compound.m_128405_("mode", info2.getMode().ordinal());
        compound.m_128344_("gui", (byte)info2.getGuiScale().ordinal());
    }
}

