/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.client.renderer.VBORenderer;
import com.direwolf20.buildinggadgets2.client.screen.widgets.ScrollingMaterialList;
import com.direwolf20.buildinggadgets2.common.blockentities.TemplateManagerBE;
import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.Redprint;
import com.direwolf20.buildinggadgets2.common.items.TemplateItem;
import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketUpdateTemplateManager;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2DataClient;
import com.direwolf20.buildinggadgets2.util.FakeRenderingWorld;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.PasteData;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.Template;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class TemplateManagerGUI
extends AbstractContainerScreen<TemplateManagerContainer> {
    private static final ResourceLocation background = new ResourceLocation("buildinggadgets2", "textures/gui/template_manager.png");
    private final Rect2i panel = new Rect2i(-12, 12, 136, 80);
    private boolean panelClicked;
    private int clickButton;
    private int clickX;
    private int clickY;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float initPanX;
    private float initPanY;
    private float momentumX;
    private float momentumY;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private EditBox nameField;
    private Button buttonSave;
    private Button buttonLoad;
    private Button buttonCopy;
    private Button buttonPaste;
    private Button buttonToggleViewport;
    private int renderSlot = 0;
    public static UUID gadgetUUID = UUID.randomUUID();
    public static UUID templateUUID = UUID.randomUUID();
    public static UUID copyPasteUUIDCache = UUID.randomUUID();
    private static ArrayList<StatePos> statePosCache;
    private final TemplateManagerBE be;
    private final TemplateManagerContainer container;
    private ScrollingMaterialList scrollingList;
    private boolean showMaterialList = false;
    private static final Map<RenderType, VertexBuffer> vertexBuffers;

    public TemplateManagerGUI(TemplateManagerContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, (Component)Component.m_237113_((String)""));
        this.container = container;
        this.be = container.getTe();
    }

    public void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this.f_96547_);
        this.nameField = new EditBox(this.f_96547_, this.f_97735_ - 20 + 8, this.f_97736_ - 5, this.f_97726_ - 16, 9 + 3, (Component)Component.m_237115_((String)"buildinggadgets2.screen.namefieldtext"));
        this.updateNameField();
        int x = this.f_97735_ - 20 + 180;
        this.buttonSave = new ExtendedButton(x, this.f_97736_ + 15, 60, 15, (Component)Component.m_237115_((String)"buildinggadgets2.buttons.save"), button -> this.onSave());
        this.buttonLoad = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"buildinggadgets2.buttons.load"), b -> this.onLoad()).m_252794_(x, this.f_97736_ + 32).m_253046_(60, 15).m_253136_());
        this.buttonCopy = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"buildinggadgets2.buttons.copy"), b -> this.onCopy()).m_252794_(x, this.f_97736_ + 50).m_253046_(60, 15).m_253136_());
        this.buttonPaste = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"buildinggadgets2.buttons.paste"), b -> this.onPaste()).m_252794_(x, this.f_97736_ + 67).m_253046_(60, 15).m_253136_());
        this.buttonToggleViewport = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"buildinggadgets2.buttons.render"), b -> this.onToggleViewport()).m_252794_(x, this.f_97736_ + 85).m_253046_(60, 15).m_253136_());
        this.renderSlot = 1;
        this.m_142416_((GuiEventListener)this.buttonSave);
        this.nameField.m_94199_(50);
        this.nameField.m_94194_(true);
        this.m_142416_((GuiEventListener)this.nameField);
        this.scrollingList = new ScrollingMaterialList((Screen)this, this.f_97735_ + this.panel.m_110085_(), this.f_97736_ + this.panel.m_110086_(), this.panel.m_110090_(), this.panel.m_110091_(), this.container.m_38853_(this.renderSlot).m_7993_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.updateAsNeeded();
        if (this.showMaterialList) {
            if (!this.f_169369_.contains((Object)this.scrollingList)) {
                this.m_142416_((GuiEventListener)this.scrollingList);
            }
        } else {
            this.m_169411_((GuiEventListener)this.scrollingList);
            guiGraphics.m_280262_();
            this.renderPanel(guiGraphics);
        }
    }

    public void updateNameField() {
        ItemStack gadgetStack = this.container.m_38853_(0).m_7993_();
        ItemStack templateStack = this.container.m_38853_(1).m_7993_();
        String gadgetName = GadgetNBT.getTemplateName(gadgetStack);
        String templateName = GadgetNBT.getTemplateName(templateStack);
        this.nameField.m_94144_(templateName.isEmpty() ? gadgetName : templateName);
    }

    public void updateAsNeeded() {
        ItemStack gadgetStack = this.container.m_38853_(0).m_7993_();
        ItemStack templateStack = this.container.m_38853_(1).m_7993_();
        boolean updatePanel = false;
        UUID gadgetStackUUID = GadgetNBT.getUUID(gadgetStack);
        UUID templateStackUUID = GadgetNBT.getUUID(templateStack);
        if (!gadgetStackUUID.equals(gadgetUUID)) {
            gadgetUUID = gadgetStackUUID;
            updatePanel = true;
        }
        if (!templateStackUUID.equals(templateUUID)) {
            templateUUID = templateStackUUID;
            updatePanel = true;
        }
        if (updatePanel) {
            this.updateNameField();
        }
        this.updatePanelIfNeeded();
    }

    public boolean updatePanelIfNeeded() {
        ItemStack gadget = this.container.m_38853_(this.renderSlot).m_7993_();
        UUID gadgetUUID = GadgetNBT.getUUID(gadget);
        if (gadget.m_41619_() || !(gadget.m_41720_() instanceof GadgetCopyPaste) && !(gadget.m_41720_() instanceof TemplateItem) && !(gadget.m_41720_() instanceof Redprint) && !(gadget.m_41720_() instanceof GadgetCutPaste)) {
            copyPasteUUIDCache = UUID.randomUUID();
            this.resetViewport();
            this.scrollingList.setTemplateItem(gadget);
            return false;
        }
        if (!BG2DataClient.isClientUpToDate(gadget)) {
            return false;
        }
        UUID BG2ClientUUID = BG2DataClient.getCopyUUID(gadgetUUID);
        if (BG2ClientUUID != null && copyPasteUUIDCache.equals(BG2ClientUUID)) {
            return false;
        }
        copyPasteUUIDCache = BG2ClientUUID;
        statePosCache = BG2DataClient.getLookupFromUUID(gadgetUUID);
        VBORenderer.generateRender((Level)this.getMinecraft().f_91073_, BlockPos.f_121853_, gadget, 1.0f, statePosCache, vertexBuffers);
        this.scrollingList.setTemplateItem(gadget);
        return true;
    }

    private void renderPanel(GuiGraphics guiGraphics) {
        double scale = this.getMinecraft().m_91268_().m_85449_();
        ItemStack gadget = this.container.m_38853_(this.renderSlot).m_7993_();
        if (gadget.m_41619_()) {
            return;
        }
        ArrayList<StatePos> statePosCache = BG2DataClient.getLookupFromUUID(GadgetNBT.getUUID(gadget));
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        BlockPos startPos = statePosCache.get((int)0).pos;
        BlockPos endPos = statePosCache.get((int)(statePosCache.size() - 1)).pos;
        float lengthX = Math.abs(startPos.m_123341_() - endPos.m_123341_());
        float lengthY = Math.abs(startPos.m_123342_() - endPos.m_123342_());
        float lengthZ = Math.abs(startPos.m_123343_() - endPos.m_123343_());
        float maxW = 96.0f;
        float maxH = 176.0f;
        float overW = Math.max(lengthX * 16.0f - 96.0f, lengthZ * 16.0f - 96.0f);
        float overH = lengthY * 16.0f - 176.0f;
        float sc = 1.0f;
        float zoomScale = 1.0f;
        if (overW > 0.0f && overW >= overH) {
            sc = 96.0f / (overW + 96.0f);
            zoomScale = overW / 40.0f;
        } else if (overH > 0.0f && overH >= overW) {
            sc = 176.0f / (overH + 176.0f);
            zoomScale = overH / 40.0f;
        }
        int x1 = (int)Math.round((double)(this.f_97735_ + this.panel.m_110085_()) * scale);
        int y1 = (int)Math.round((double)this.getMinecraft().m_91268_().m_85442_() - (double)(this.f_97736_ + this.panel.m_110086_() + this.panel.m_110091_()) * scale);
        int x2 = (int)Math.round((double)this.panel.m_110090_() * scale);
        int y2 = (int)Math.round((double)this.panel.m_110091_() * scale);
        RenderSystem.viewport((int)x1, (int)y1, (int)x2, (int)y2);
        RenderSystem.backupProjectionMatrix();
        float fov = 60.0f;
        float aspectRatio = (float)this.f_96543_ / (float)this.f_96544_;
        float near = 0.1f;
        float far = 1000.0f;
        Matrix4f projectionMatrix = new Matrix4f();
        projectionMatrix.setPerspective((float)Math.toRadians(fov), aspectRatio, near, far);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_166856_();
        poseStack.m_252880_(-lengthZ / 2.0f + this.panX, -lengthY / 2.0f - this.panY, -lengthZ + this.zoom);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(this.rotX / 180.0f * (float)Math.PI, 1.0f, 0.0f, 0.0f));
        poseStack.m_252781_(new Quaternionf().setAngleAxis(this.rotY / 180.0f * (float)Math.PI, 0.0f, 1.0f, 0.0f));
        RenderSystem.applyModelViewMatrix();
        RenderSystem.clear((int)256, (boolean)false);
        RenderSystem.runAsFancy(() -> this.drawRenderScreen(poseStack, (Player)Minecraft.m_91087_().f_91074_, statePosCache));
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.viewport((int)0, (int)0, (int)this.getMinecraft().m_91268_().m_85441_(), (int)this.getMinecraft().m_91268_().m_85442_());
        RenderSystem.restoreProjectionMatrix();
    }

    public void drawRenderScreen(PoseStack matrix, Player player, ArrayList<StatePos> statePosCache) {
        if (this.container.m_38853_(1).m_7993_().m_41619_()) {
            return;
        }
        MultiBufferSource.BufferSource buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.m_110451_());
        drawSet.add(RenderType.m_110463_());
        drawSet.add(RenderType.m_110457_());
        drawSet.add(RenderType.m_110466_());
        drawSet.add(RenderType.m_110503_());
        try {
            for (RenderType renderType : drawSet) {
                RenderType drawRenderType = renderType.equals(RenderType.m_110463_()) ? OurRenderTypes.RenderBlock : RenderType.m_110466_();
                VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
                if (vertexBuffer.m_166892_() == null) continue;
                drawRenderType.m_110185_();
                vertexBuffer.m_85921_();
                vertexBuffer.m_253207_(matrix.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                VertexBuffer.m_85931_();
                drawRenderType.m_110188_();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        matrix.m_85836_();
        matrix.m_166856_();
        MyRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MyRenderMethods.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)buffersource, 1.0f);
        FakeRenderingWorld fakeRenderingWorld = new FakeRenderingWorld(player.m_9236_(), statePosCache, BlockPos.f_121853_);
        for (StatePos pos2 : statePosCache.stream().filter(pos -> !VBORenderer.isModelRender(pos.state)).toList()) {
            if (pos2.state.m_60795_()) continue;
            matrix.m_85836_();
            matrix.m_252880_((float)pos2.pos.m_123341_(), (float)pos2.pos.m_123342_(), (float)pos2.pos.m_123343_());
            BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.m_91087_().m_167982_();
            BlockEntity blockEntity = fakeRenderingWorld.m_7702_(pos2.pos);
            if (blockEntity != null) {
                BlockEntityRenderer renderer = blockEntityRenderer.m_112265_(blockEntity);
                try {
                    renderer.m_6922_(blockEntity, 0.0f, matrix, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, 0xF00000, OverlayTexture.f_118083_);
                }
                catch (Exception exception) {}
            } else {
                try {
                    MyRenderMethods.renderBETransparent(fakeRenderingWorld.m_8055_(pos2.pos), matrix, (MultiBufferSource)buffersource, 0xF00000, 655360, 0.5f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            matrix.m_85849_();
        }
        matrix.m_85849_();
        buffersource.m_173043_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(background, this.f_97735_ - 20, this.f_97736_ - 12, 0, 0, this.f_97726_, this.f_97727_ + 25);
        guiGraphics.m_280218_(background, this.f_97735_ - 20 + this.f_97726_, this.f_97736_ + 8, this.f_97726_ + 3, 30, 71, this.f_97727_);
        if (!this.buttonCopy.m_274382_() && !this.buttonPaste.m_274382_()) {
            if (this.buttonLoad.m_274382_()) {
                guiGraphics.m_280218_(background, this.f_97735_ + this.f_97726_ - 44, this.f_97736_ + 38, this.f_97726_, 0, 17, 24);
            } else {
                guiGraphics.m_280218_(background, this.f_97735_ + this.f_97726_ - 44, this.f_97736_ + 38, this.f_97726_ + 17, 0, 16, 24);
            }
        }
        this.nameField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void resetViewport() {
        this.rotX = 0.0f;
        this.rotY = 0.0f;
        this.zoom = 1.0f;
        this.momentumX = 0.0f;
        this.momentumY = 0.0f;
        this.panX = 0.0f;
        this.panY = 0.0f;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.panel.m_110087_((int)mouseX - this.f_97735_, (int)mouseY - this.f_97736_)) {
            if (this.showMaterialList) {
                this.m_7522_((GuiEventListener)this.scrollingList);
            } else {
                this.clickButton = mouseButton;
                this.panelClicked = true;
                this.clickX = (int)this.getMinecraft().f_91067_.m_91589_();
                this.clickY = (int)this.getMinecraft().f_91067_.m_91594_();
            }
        }
        if (!this.panel.m_110087_((int)mouseX - this.f_97735_, (int)mouseY - this.f_97736_)) {
            this.scrollingList.m_6987_(null);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initPanX = this.panX;
        this.initPanY = this.panY;
        this.initZoom = this.zoom;
        return super.m_6348_(mouseX, mouseY, state);
    }

    public boolean m_7979_(double x, double y, int button, double dx, double dy) {
        if (this.showMaterialList) {
            return this.m_7222_() != null && this.m_7282_() && button == 0 ? this.m_7222_().m_7979_(x, y, button, dx, dy) : false;
        }
        return super.m_7979_(x, y, button, dx, dy);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.m_7379_();
            return true;
        }
        return this.nameField.m_93696_() ? this.nameField.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                float prevRotX = this.rotX;
                float prevRotY = this.rotY;
                this.rotX = this.initRotX - (float)((int)this.getMinecraft().f_91067_.m_91594_() - this.clickY);
                this.rotY = this.initRotY + (float)((int)this.getMinecraft().f_91067_.m_91589_() - this.clickX);
            } else if (this.clickButton == 1) {
                this.panX = this.initPanX + (float)((int)this.getMinecraft().f_91067_.m_91589_() - this.clickX) / 8.0f;
                this.panY = this.initPanY + (float)((int)this.getMinecraft().f_91067_.m_91594_() - this.clickY) / 8.0f;
            } else if (this.clickButton == 2) {
                this.resetViewport();
            }
        }
        this.rotX += this.momentumX;
        this.rotY += this.momentumY;
        float momentumDampening = 0.98f;
        this.momentumX *= momentumDampening;
        this.momentumY *= momentumDampening;
        if (!this.nameField.m_93696_() && this.nameField.m_94155_().isEmpty()) {
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"buildinggadgets2.screen.templateplaceholder"), this.nameField.m_252754_() - this.f_97735_ + 4, this.nameField.m_252907_() + 2 - this.f_97736_, -10197916);
        }
        if (this.buttonSave.m_274382_() || this.buttonLoad.m_274382_() || this.buttonPaste.m_274382_()) {
            this.drawSlotOverlay(guiGraphics, this.buttonLoad.m_274382_() ? this.container.m_38853_(0) : this.container.m_38853_(1));
        }
    }

    private void drawSlotOverlay(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        guiGraphics.m_280509_(slot.f_40220_, slot.f_40221_, slot.f_40220_ + 16, slot.f_40221_ + 16, -1660903937);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.zoom = this.initZoom + (float)scrollDelta * 2.0f;
        if (this.zoom < -200.0f) {
            this.zoom = -200.0f;
        }
        if (this.zoom > 5000.0f) {
            this.zoom = 5000.0f;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.nameField.m_94120_();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.initPanX = this.panX;
            this.initPanY = this.panY;
        }
    }

    private void onToggleViewport() {
        boolean bl = this.showMaterialList = !this.showMaterialList;
        if (this.showMaterialList) {
            this.buttonToggleViewport.m_93666_((Component)Component.m_237115_((String)"buildinggadgets2.buttons.materials"));
        } else {
            this.buttonToggleViewport.m_93666_((Component)Component.m_237115_((String)"buildinggadgets2.buttons.render"));
        }
    }

    private void onSave() {
        PacketHandler.sendToServer(new PacketUpdateTemplateManager(this.be.m_58899_(), 0, this.nameField.m_94155_()));
    }

    private void onLoad() {
        PacketHandler.sendToServer(new PacketUpdateTemplateManager(this.be.m_58899_(), 1, this.nameField.m_94155_()));
    }

    private Template getTemplate() {
        ItemStack templateStack = this.container.m_38853_(1).m_7993_();
        Template template = new Template("", new ArrayList<StatePos>());
        if (templateStack.m_41619_()) {
            return template;
        }
        UUID templateUUID = GadgetNBT.getUUID(templateStack);
        ArrayList<StatePos> statePosCache = BG2DataClient.getLookupFromUUID(templateUUID);
        if (statePosCache == null || statePosCache.isEmpty()) {
            return template;
        }
        template = new Template(this.nameField.m_94155_(), statePosCache);
        return template;
    }

    private void onCopy() {
        Template template = this.getTemplate();
        if (template.statePosArrayList.isEmpty()) {
            return;
        }
        try {
            String json = template.toJson();
            this.getMinecraft().f_91068_.m_90911_(json);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void onPaste() {
        assert (this.getMinecraft().f_91074_ != null);
        String CBString = this.getMinecraft().f_91068_.m_90876_();
        ArrayList<Object> statePosArrayList = new ArrayList();
        try {
            Template template = new Template(CBString);
            if (template.statePosArrayList == null || template.statePosArrayList.equals("")) {
                return;
            }
            CompoundTag deserializedNBT = TagParser.m_129359_((String)template.statePosArrayList);
            statePosArrayList = BG2Data.statePosListFromNBTMapArray(deserializedNBT);
        }
        catch (Exception e) {
            this.getMinecraft().f_91074_.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.screen.invalidjson"), true);
            return;
        }
        if (statePosArrayList.isEmpty()) {
            return;
        }
        CompoundTag serverTag = BG2Data.statePosListToNBTMapArray(statePosArrayList);
        PasteData.sendCompoundTag(serverTag);
    }

    private void onReplace(BlockState targetState) {
        if (!this.showMaterialList || this.scrollingList.m_93511_() == null) {
            return;
        }
    }

    private void doReplace(BlockState sourceState, BlockState targetState) {
        Template template = this.getTemplate();
        if (template.statePosArrayList.isEmpty()) {
            return;
        }
        template.replaceBlocks(sourceState, targetState);
    }

    static {
        vertexBuffers = RenderType.m_110506_().stream().collect(Collectors.toMap(renderType -> renderType, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
    }
}

