/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeConfigHelper {
    private static final Method MOD_CONFIG_SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
    private static final Method MOD_CONFIG_FIRE_EVENT = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"fireEvent", (Class[])new Class[]{IConfigEvent.class});

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllForgeConfigValues(UnmodifiableConfig config, ForgeConfigSpec spec) {
        ArrayList values = new ArrayList();
        ForgeConfigHelper.gatherValuesFromForgeConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromForgeConfig(UnmodifiableConfig config, ForgeConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                ForgeConfigHelper.gatherValuesFromForgeConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    public static void setForgeConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        try {
            MOD_CONFIG_SET_CONFIG_DATA.invoke((Object)config, configData);
            if (configData instanceof FileConfig) {
                config.save();
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig getForgeConfig(String fileName) {
        return (ModConfig)ConfigTracker.INSTANCE.fileMap().get(fileName);
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllForgeConfigValues(ModConfig config) {
        return ForgeConfigHelper.gatherAllForgeConfigValues(((ForgeConfigSpec)config.getSpec()).getValues(), (ForgeConfigSpec)config.getSpec());
    }

    public static void fireForgeConfigEvent(ModConfig config, ModConfigEvent event) {
        try {
            MOD_CONFIG_FIRE_EVENT.invoke((Object)config, event);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ForgeConfigSpec findConfigSpec(UnmodifiableConfig config) {
        if (config instanceof ForgeConfigSpec) {
            ForgeConfigSpec spec = (ForgeConfigSpec)config;
            return spec;
        }
        if (config instanceof UnmodifiableConfigWrapper) {
            try {
                Field field = UnmodifiableConfigWrapper.class.getDeclaredField("config");
                field.setAccessible(true);
                return ForgeConfigHelper.findConfigSpec(MethodHandles.lookup().unreflectGetter(field).invoke(config));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

