/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncCurios;
import top.theillusivec4.curios.common.slottype.LegacySlotManager;
import top.theillusivec4.curios.server.command.CurioArgumentType;

public class CuriosCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder curiosCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"curios").requires(player -> player.m_6761_(2));
        curiosCommand.then(Commands.m_82127_((String)"list").executes(context -> {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(LegacySlotManager.getIdsToMods());
            for (Map.Entry<String, Set<String>> entry : CuriosSlotManager.SERVER.getModsFromSlots().entrySet()) {
                map.computeIfAbsent(entry.getKey(), k -> new HashSet()).addAll((Collection)entry.getValue());
            }
            for (Map.Entry<String, Set<String>> entry : CuriosEntityManager.SERVER.getModsFromSlots().entrySet()) {
                map.computeIfAbsent(entry.getKey(), k -> new HashSet()).addAll((Collection)entry.getValue());
            }
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)((String)entry.getKey() + " - " + String.join((CharSequence)", ", (Iterable)entry.getValue()))), false);
            }
            return 1;
        }));
        curiosCommand.then(Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"with").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(context -> CuriosCommand.replaceItemForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), ItemArgument.m_120963_((CommandContext)context, (String)"item")))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.replaceItemForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), ItemArgument.m_120963_((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"))))))))));
        curiosCommand.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CuriosCommand.setSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.setSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CuriosCommand.growSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.growSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CuriosCommand.shrinkSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.shrinkSlotForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CuriosCommand.clearSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ""))).then(Commands.m_82129_((String)"slot", (ArgumentType)CurioArgumentType.slot()).executes(context -> CuriosCommand.clearSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"))))));
        curiosCommand.then(Commands.m_82127_((String)"drop").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CuriosCommand.dropSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ""))).then(Commands.m_82129_((String)"slot", (ArgumentType)CurioArgumentType.slot()).executes(context -> CuriosCommand.dropSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSourceStack>)context, "slot"))))));
        curiosCommand.then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CuriosCommand.resetSlotsForPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        dispatcher.register(curiosCommand);
    }

    private static int replaceItemForPlayer(CommandSourceStack source, ServerPlayer player, String slot, int index, ItemInput item) throws CommandSyntaxException {
        return CuriosCommand.replaceItemForPlayer(source, player, slot, index, item, 1);
    }

    private static int replaceItemForPlayer(CommandSourceStack source, ServerPlayer player, String slot, int index, ItemInput item, int count) throws CommandSyntaxException {
        ItemStack stack = item.m_120980_(count, false);
        CuriosApi.getCuriosHelper().setEquippedCurio((LivingEntity)player, slot, index, stack);
        source.m_288197_(() -> Component.m_237110_((String)"commands.curios.replace.success", (Object[])new Object[]{slot, player.m_5446_(), stack.m_41611_()}), true);
        return 1;
    }

    private static int setSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().setSlotsForType(slot, (LivingEntity)playerMP, amount);
        source.m_288197_(() -> Component.m_237110_((String)"commands.curios.set.success", (Object[])new Object[]{slot, CuriosApi.getSlotHelper().getSlotsForType((LivingEntity)playerMP, slot), playerMP.m_5446_()}), true);
        return 1;
    }

    private static int growSlotForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().growSlotType(slot, amount, (LivingEntity)playerMP);
        source.m_288197_(() -> Component.m_237110_((String)"commands.curios.add.success", (Object[])new Object[]{amount, slot, playerMP.m_5446_()}), true);
        return 1;
    }

    private static int shrinkSlotForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().shrinkSlotType(slot, amount, (LivingEntity)playerMP);
        source.m_288197_(() -> Component.m_237110_((String)"commands.curios.remove.success", (Object[])new Object[]{amount, slot, playerMP.m_5446_()}), true);
        return 1;
    }

    private static int dropSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            if (!slot.isEmpty() && curios.get(slot) != null) {
                CuriosCommand.drop(curios.get(slot), playerMP);
            } else {
                for (String id : curios.keySet()) {
                    CuriosCommand.drop(curios.get(id), playerMP);
                }
            }
        });
        if (slot.isEmpty()) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.curios.dropAll.success", (Object[])new Object[]{playerMP.m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.curios.drop.success", (Object[])new Object[]{slot, playerMP.m_5446_()}), true);
        }
        return 1;
    }

    private static void drop(ICurioStacksHandler stacksHandler, ServerPlayer serverPlayer) {
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            ItemStack stack1 = stacksHandler.getStacks().getStackInSlot(i);
            stacksHandler.getStacks().setStackInSlot(i, ItemStack.f_41583_);
            ItemStack stack2 = stacksHandler.getCosmeticStacks().getStackInSlot(i);
            stacksHandler.getCosmeticStacks().setStackInSlot(i, ItemStack.f_41583_);
            if (!stack1.m_41619_()) {
                serverPlayer.m_7197_(stack1, true, false);
            }
            if (stack2.m_41619_()) continue;
            serverPlayer.m_7197_(stack2, true, false);
        }
    }

    private static int clearSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP, String slot) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            if (!slot.isEmpty() && curios.get(slot) != null) {
                CuriosCommand.clear(curios.get(slot));
            } else {
                for (String id : curios.keySet()) {
                    CuriosCommand.clear(curios.get(id));
                }
            }
        });
        if (slot.isEmpty()) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.curios.clearAll.success", (Object[])new Object[]{playerMP.m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.curios.clear.success", (Object[])new Object[]{slot, playerMP.m_5446_()}), true);
        }
        return 1;
    }

    private static int resetSlotsForPlayer(CommandSourceStack source, ServerPlayer playerMP) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            handler.reset();
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new SPacketSyncCurios(playerMP.m_19879_(), handler.getCurios()));
        });
        source.m_288197_(() -> Component.m_237110_((String)"commands.curios.reset.success", (Object[])new Object[]{playerMP.m_5446_()}), true);
        return 1;
    }

    private static void clear(ICurioStacksHandler stacksHandler) {
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            stacksHandler.getStacks().setStackInSlot(i, ItemStack.f_41583_);
            stacksHandler.getCosmeticStacks().setStackInSlot(i, ItemStack.f_41583_);
        }
    }
}

