/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.create.foundation.utility.NBTHelper;
import nl.requios.effortlessbuilding.network.ModifierSettingsPacket;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.utilities.BlockSet;

@OnlyIn(value=Dist.CLIENT)
public class BuildModifiers {
    private List<BaseModifier> modifierSettingsList = new ArrayList<BaseModifier>();

    public List<BaseModifier> getModifierSettingsList() {
        return Collections.unmodifiableList(this.modifierSettingsList);
    }

    public void addModifierSettings(BaseModifier modifierSettings) {
        this.modifierSettingsList.add(modifierSettings);
    }

    public void removeModifierSettings(BaseModifier modifierSettings) {
        this.modifierSettingsList.remove(modifierSettings);
    }

    public void removeModifierSettings(int index) {
        this.modifierSettingsList.remove(index);
    }

    public void moveUp(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == 0) {
            return;
        }
        Collections.swap(this.modifierSettingsList, index, index - 1);
    }

    public void moveDown(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == this.modifierSettingsList.size() - 1) {
            return;
        }
        Collections.swap(this.modifierSettingsList, index, index + 1);
    }

    public void setFirst(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == 0) {
            return;
        }
        this.modifierSettingsList.remove(index);
        this.modifierSettingsList.add(0, modifierSettings);
    }

    public void setLast(BaseModifier modifierSettings) {
        int index = this.modifierSettingsList.indexOf(modifierSettings);
        if (index == this.modifierSettingsList.size() - 1) {
            return;
        }
        this.modifierSettingsList.remove(index);
        this.modifierSettingsList.add(modifierSettings);
    }

    public void clearAllModifierSettings() {
        this.modifierSettingsList.clear();
    }

    public void findCoordinates(BlockSet blocks, Player player) {
        for (BaseModifier modifierSettings : this.modifierSettingsList) {
            modifierSettings.findCoordinates(blocks, player);
        }
    }

    public void onPowerLevelChanged(int powerLevel) {
        for (BaseModifier modifierSettings : this.modifierSettingsList) {
            modifierSettings.onPowerLevelChanged(powerLevel);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("modifierSettingsList", (Tag)NBTHelper.writeCompoundList(this.modifierSettingsList, BaseModifier::serializeNBT));
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        ListTag listTag = compoundTag.m_128437_("modifierSettingsList", 10);
        this.modifierSettingsList = NBTHelper.readCompoundList(listTag, tag -> {
            BaseModifier modifier = this.createModifier(tag.m_128461_("type"));
            modifier.deserializeNBT((CompoundTag)tag);
            return modifier;
        });
    }

    public void save() {
        PacketHandler.INSTANCE.sendToServer((Object)new ModifierSettingsPacket(this.serializeNBT()));
    }

    private BaseModifier createModifier(String type) {
        switch (type) {
            case "Mirror": {
                return new Mirror();
            }
            case "Array": {
                return new Array();
            }
            case "RadialMirror": {
                return new RadialMirror();
            }
        }
        throw new IllegalArgumentException("Unknown modifier type: " + type);
    }
}

