/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.utility;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;

public class DynamicComponent {
    private JsonElement rawCustomText;
    private Component parsedCustomText;

    public void displayCustomText(Level level, BlockPos pos, String tagElement) {
        if (tagElement == null) {
            return;
        }
        this.rawCustomText = DynamicComponent.getJsonFromString(tagElement);
        this.parsedCustomText = DynamicComponent.parseCustomText(level, pos, this.rawCustomText);
    }

    public boolean sameAs(String tagElement) {
        return this.isValid() && this.rawCustomText.equals(DynamicComponent.getJsonFromString(tagElement));
    }

    public boolean isValid() {
        return this.parsedCustomText != null && this.rawCustomText != null;
    }

    public String resolve() {
        return this.parsedCustomText.getString();
    }

    public MutableComponent get() {
        return this.parsedCustomText == null ? Components.empty() : this.parsedCustomText.m_6881_();
    }

    public void read(Level level, BlockPos pos, CompoundTag nbt) {
        this.rawCustomText = DynamicComponent.getJsonFromString(nbt.m_128461_("RawCustomText"));
        try {
            this.parsedCustomText = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomText"));
        }
        catch (JsonParseException e) {
            this.parsedCustomText = null;
        }
    }

    public void write(CompoundTag nbt) {
        if (!this.isValid()) {
            return;
        }
        nbt.m_128359_("RawCustomText", this.rawCustomText.toString());
        nbt.m_128359_("CustomText", Component.Serializer.m_130703_((Component)this.parsedCustomText));
    }

    public static JsonElement getJsonFromString(String string) {
        try {
            return JsonParser.parseString((String)string);
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    public static Component parseCustomText(Level level, BlockPos pos, JsonElement customText) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        try {
            return ComponentUtils.m_130731_((CommandSourceStack)DynamicComponent.getCommandSource(serverLevel, pos), (Component)Component.Serializer.m_130691_((JsonElement)customText), null, (int)0);
        }
        catch (JsonParseException e) {
            return null;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static CommandSourceStack getCommandSource(ServerLevel level, BlockPos pos) {
        return new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)pos), Vec2.f_82462_, level, 2, "effortlessbuilding", (Component)Components.literal("effortlessbuilding"), level.m_7654_(), null);
    }
}

