/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import nl.requios.effortlessbuilding.CommonConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.capability.IPowerLevel;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReachUpgrade3Item
extends Item {
    public ReachUpgrade3Item() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        IPowerLevel powerLevel = (IPowerLevel)player.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY).orElse(null);
        if (powerLevel != null) {
            int currentLevel = powerLevel.getPowerLevel();
            if (currentLevel == 2) {
                if (!world.f_46443_) {
                    powerLevel.increasePowerLevel();
                    EffortlessBuilding.log(player, "Upgraded power level to " + powerLevel.getPowerLevel());
                    stack.m_41774_(1);
                    world.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    CapabilityHandler.syncToClient(player);
                }
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
            }
            if (currentLevel < 2) {
                if (!world.f_46443_) {
                    if (currentLevel == 0) {
                        EffortlessBuilding.log(player, "Use Reach Upgrade 1 and 2 first.");
                    }
                    if (currentLevel == 1) {
                        EffortlessBuilding.log(player, "Use Reach Upgrade 2 first.");
                    }
                    world.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (currentLevel > 2 && !world.f_46443_) {
                EffortlessBuilding.log(player, "Already used this upgrade! Current power level is " + powerLevel.getPowerLevel() + ".");
                world.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Consume to increase reach to " + ChatFormatting.BLUE + CommonConfig.reach.level3.get())));
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Previous upgrades need to be consumed first")));
    }
}

