/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import org.jetbrains.annotations.NotNull;

public class BlockSet
extends HashMap<BlockPos, BlockEntry>
implements Iterable<BlockEntry> {
    public static boolean logging = true;
    public BlockPos firstPos;
    public BlockPos lastPos;
    public boolean skipFirst;

    public BlockSet() {
    }

    public BlockSet(BlockSet blockSet) {
        super(blockSet);
        this.firstPos = blockSet.firstPos;
        this.lastPos = blockSet.lastPos;
        this.skipFirst = blockSet.skipFirst;
    }

    public BlockSet(List<BlockEntry> blockEntries, BlockPos firstPos, BlockPos lastPos, boolean skipFirst) {
        for (BlockEntry blockEntry : blockEntries) {
            this.add(blockEntry);
        }
        this.firstPos = firstPos;
        this.lastPos = lastPos;
        this.skipFirst = skipFirst;
    }

    public void setStartPos(BlockEntry startPos) {
        this.clear();
        this.add(startPos);
        this.firstPos = startPos.blockPos;
        this.lastPos = startPos.blockPos;
    }

    public void add(BlockEntry blockEntry) {
        if (!this.containsKey(blockEntry.blockPos)) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (!ClientSide.isFull(this)) {
                    this.put(blockEntry.blockPos, blockEntry);
                }
            });
            DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> this.put(blockEntry.blockPos, blockEntry));
        } else if (logging) {
            EffortlessBuilding.log("BlockSet already contains block at " + blockEntry.blockPos);
        }
    }

    public HashSet<BlockPos> getCoordinates() {
        return new HashSet<BlockPos>(this.keySet());
    }

    public BlockEntry getFirstBlockEntry() {
        return (BlockEntry)this.get(this.firstPos);
    }

    public BlockEntry getLastBlockEntry() {
        return (BlockEntry)this.get(this.lastPos);
    }

    @Override
    @NotNull
    public Iterator<BlockEntry> iterator() {
        return this.values().iterator();
    }

    public static void encode(FriendlyByteBuf buf, BlockSet block) {
        buf.m_236828_(block.values().stream().filter(be -> !be.invalid).toList(), BlockEntry::encode);
        buf.m_130064_(block.firstPos);
        buf.m_130064_(block.lastPos);
        buf.writeBoolean(block.skipFirst);
    }

    public static BlockSet decode(FriendlyByteBuf buf) {
        return new BlockSet(buf.m_236845_(BlockEntry::decode), buf.m_130135_(), buf.m_130135_(), buf.readBoolean());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientSide {
        public static boolean isFull(BlockSet blockSet) {
            int limit = CapabilityHandler.getMaxBlocksPlacedAtOnce((Player)Minecraft.m_91087_().f_91074_, false);
            if (blockSet.size() >= limit) {
                if (logging) {
                    EffortlessBuilding.log("BlockSet limit reached, not adding block.");
                }
                return true;
            }
            return false;
        }
    }
}

