/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeDecorator;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.ApiStatus;

public interface EmiRegistry {
    public RecipeManager getRecipeManager();

    public void addCategory(EmiRecipeCategory var1);

    public void addWorkstation(EmiRecipeCategory var1, EmiIngredient var2);

    public void addRecipe(EmiRecipe var1);

    public void removeRecipes(Predicate<EmiRecipe> var1);

    default public void removeRecipes(ResourceLocation id) {
        this.removeRecipes((EmiRecipe r) -> id.equals((Object)r.getId()));
    }

    public void addDeferredRecipes(Consumer<Consumer<EmiRecipe>> var1);

    public void addEmiStack(EmiStack var1);

    public void addEmiStackAfter(EmiStack var1, Predicate<EmiStack> var2);

    default public void addEmiStackAfter(EmiStack stack, EmiStack other) {
        this.addEmiStackAfter(stack, (EmiStack s) -> s.equals(other));
    }

    public void removeEmiStacks(Predicate<EmiStack> var1);

    default public void removeEmiStacks(EmiStack stack) {
        this.removeEmiStacks((EmiStack s) -> s.equals(stack));
    }

    @Deprecated
    public <T extends EmiIngredient> void addIngredientSerializer(Class<T> var1, EmiIngredientSerializer<T> var2);

    public <T extends Screen> void addExclusionArea(Class<T> var1, EmiExclusionArea<T> var2);

    public void addGenericExclusionArea(EmiExclusionArea<Screen> var1);

    public <T extends Screen> void addDragDropHandler(Class<T> var1, EmiDragDropHandler<T> var2);

    public void addGenericDragDropHandler(EmiDragDropHandler<Screen> var1);

    public <T extends Screen> void addStackProvider(Class<T> var1, EmiStackProvider<T> var2);

    public void addGenericStackProvider(EmiStackProvider<Screen> var1);

    public void setDefaultComparison(Object var1, Function<Comparison, Comparison> var2);

    default public void setDefaultComparison(Object key, Comparison comparison) {
        this.setDefaultComparison(key, (Comparison old) -> comparison);
    }

    default public void setDefaultComparison(EmiStack stack, Function<Comparison, Comparison> comparison) {
        this.setDefaultComparison(stack.getKey(), comparison);
    }

    default public void setDefaultComparison(EmiStack stack, Comparison comparison) {
        this.setDefaultComparison(stack.getKey(), (Comparison old) -> comparison);
    }

    public <T extends AbstractContainerMenu> void addRecipeHandler(MenuType<T> var1, EmiRecipeHandler<T> var2);

    @ApiStatus.Experimental
    public void addRecipeDecorator(EmiRecipeDecorator var1);

    @ApiStatus.Experimental
    default public void addRecipeDecorator(EmiRecipeCategory category, EmiRecipeDecorator decorator) {
        this.addRecipeDecorator((recipe, widgets) -> {
            if (recipe.getCategory() == category) {
                decorator.decorateRecipe(recipe, widgets);
            }
        });
    }
}

