/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.config;

import com.mojang.blaze3d.platform.InputConstants;
import dev.emi.emi.com.unascribed.qdcss.QDCSS;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.HeaderType;
import dev.emi.emi.config.ScreenAlign;
import dev.emi.emi.config.SidebarPages;
import dev.emi.emi.config.SidebarTheme;
import dev.emi.emi.config.SidebarType;
import dev.emi.emi.input.EmiBind;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ConfigPresets {
    @EmiConfig.ConfigGroup(value="presets.sidebars")
    @EmiConfig.Comment(value="Index on the right, a smaller set of craftables on the left, and favorites in the top left. Ideal for getting the most out of EMI's features")
    @EmiConfig.ConfigValue(value="presets.productive")
    public static Runnable productive = () -> {
        ConfigPresets.setPages(EmiConfig.rightSidebarPages, List.of(new SidebarPages.SidebarPage(SidebarType.INDEX)));
        ConfigPresets.setPages(EmiConfig.leftSidebarPages, List.of(new SidebarPages.SidebarPage(SidebarType.CRAFTABLES)));
        ConfigPresets.setPages(EmiConfig.topSidebarPages, List.of(new SidebarPages.SidebarPage(SidebarType.FAVORITES)));
        ConfigPresets.setPages(EmiConfig.bottomSidebarPages, List.of());
        EmiConfig.leftSidebarTheme = SidebarTheme.MODERN;
        EmiConfig.leftSidebarHeader = HeaderType.VISIBLE;
        Minecraft client = Minecraft.m_91087_();
        if (client.m_91268_().m_85446_() < 260) {
            EmiConfig.leftSidebarSize.values.set(0, 10);
            EmiConfig.leftSidebarSize.values.set(1, 8);
        } else {
            EmiConfig.leftSidebarSize.values.set(0, 10);
            EmiConfig.leftSidebarSize.values.set(1, 10);
        }
        EmiConfig.leftSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.RIGHT, ScreenAlign.Vertical.CENTER);
        EmiConfig.rightSidebarTheme = SidebarTheme.MODERN;
        EmiConfig.rightSidebarHeader = HeaderType.VISIBLE;
        EmiConfig.rightSidebarSize.values.set(0, 12);
        EmiConfig.rightSidebarSize.values.set(1, 100);
        EmiConfig.rightSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.RIGHT, ScreenAlign.Vertical.TOP);
        EmiConfig.topSidebarTheme = SidebarTheme.TRANSPARENT;
        EmiConfig.topSidebarHeader = HeaderType.INVISIBLE;
        EmiConfig.topSidebarSize.values.set(0, 12);
        EmiConfig.topSidebarSize.values.set(1, 4);
        EmiConfig.topSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.LEFT, ScreenAlign.Vertical.TOP);
    };
    @EmiConfig.Comment(value="Use a smaller, recipe book styled panel on the left for craftables and favorites, and use a classic index on the right.")
    @EmiConfig.ConfigValue(value="presets.recipe-book-plus")
    public static Runnable recipeBookPlus = () -> {
        ConfigPresets.setPages(EmiConfig.rightSidebarPages, List.of(new SidebarPages.SidebarPage(SidebarType.INDEX)));
        ConfigPresets.setPages(EmiConfig.leftSidebarPages, List.of(new SidebarPages.SidebarPage(SidebarType.CRAFTABLES), new SidebarPages.SidebarPage(SidebarType.FAVORITES)));
        ConfigPresets.setPages(EmiConfig.topSidebarPages, List.of());
        ConfigPresets.setPages(EmiConfig.bottomSidebarPages, List.of());
        EmiConfig.leftSidebarTheme = SidebarTheme.VANILLA;
        EmiConfig.leftSidebarHeader = HeaderType.VISIBLE;
        EmiConfig.leftSidebarSize.values.set(0, 8);
        EmiConfig.leftSidebarSize.values.set(1, 7);
        EmiConfig.leftSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.RIGHT, ScreenAlign.Vertical.CENTER);
        EmiConfig.rightSidebarTheme = SidebarTheme.MODERN;
        EmiConfig.rightSidebarHeader = HeaderType.VISIBLE;
        EmiConfig.rightSidebarSize.values.set(0, 12);
        EmiConfig.rightSidebarSize.values.set(1, 100);
        EmiConfig.rightSidebarAlign = new ScreenAlign(ScreenAlign.Horizontal.RIGHT, ScreenAlign.Vertical.TOP);
    };
    @EmiConfig.Comment(value="Use index and craftables on the right panel, craftable by default, and index when searching")
    @EmiConfig.ConfigValue(value="presets.empty-search-craftable")
    public static Runnable emptySearchCraftable = () -> {
        EmiConfig.searchSidebarFocus = SidebarType.INDEX;
        EmiConfig.emptySearchSidebarFocus = SidebarType.CRAFTABLES;
        ConfigPresets.setPages(EmiConfig.rightSidebarPages, List.of(new SidebarPages.SidebarPage(SidebarType.INDEX), new SidebarPages.SidebarPage(SidebarType.CRAFTABLES)));
        ConfigPresets.setPages(EmiConfig.leftSidebarPages, List.of(new SidebarPages.SidebarPage(SidebarType.FAVORITES)));
        ConfigPresets.setPages(EmiConfig.topSidebarPages, List.of());
        ConfigPresets.setPages(EmiConfig.bottomSidebarPages, List.of());
    };
    @EmiConfig.ConfigGroup(value="presets.binds")
    @EmiConfig.Comment(value="Use some of the binds EMI's author uses, do they know best?")
    @EmiConfig.ConfigValue(value="presets.author-binds")
    public static Runnable authorBinds = () -> {
        EmiConfig.toggleVisibility.setBinds(EmiBind.ModifiedKey.of(79, 1));
        EmiConfig.focusSearch.setBinds(EmiBind.ModifiedKey.of(70, 1));
        EmiConfig.clearSearch.setBinds(EmiBind.ModifiedKey.of(68, 1));
        EmiConfig.viewRecipes.setToDefault();
        EmiConfig.viewUses.setToDefault();
        EmiConfig.favorite.setToDefault();
        EmiConfig.viewStackTree.setToDefault();
        EmiConfig.viewTree.setBinds(EmiBind.ModifiedKey.of(67, 0));
        EmiConfig.back.setToDefault();
        EmiConfig.craftOne.setToDefault();
        EmiConfig.craftAll.setBinds(new EmiBind.ModifiedKey[0]);
        EmiConfig.craftOneToInventory.setBinds(new EmiBind.ModifiedKey(InputConstants.Type.MOUSE.m_84895_(1), 4));
        EmiConfig.craftAllToInventory.setBinds(new EmiBind.ModifiedKey(InputConstants.Type.MOUSE.m_84895_(0), 4));
        EmiConfig.showCraft.setToDefault();
        EmiConfig.cheatOneToInventory.setToDefault();
        EmiConfig.cheatStackToInventory.setToDefault();
        EmiConfig.cheatOneToCursor.setToDefault();
        EmiConfig.cheatStackToCursor.setToDefault();
    };
    @EmiConfig.ConfigGroup(value="presets.restore")
    @EmiConfig.Comment(value="Restore all settings to backup from most recently launch")
    @EmiConfig.ConfigValue(value="presets.backup")
    public static Runnable backup = () -> EmiConfig.loadConfig(QDCSS.load("backup", EmiConfig.startupConfig));
    @EmiConfig.Comment(value="Restore all default settings")
    @EmiConfig.ConfigValue(value="presets.defaults")
    public static Runnable defaults = () -> EmiConfig.loadConfig(QDCSS.load("defaults", EmiConfig.DEFAULT_CONFIG));

    private static void setPages(SidebarPages pages, List<SidebarPages.SidebarPage> list) {
        pages.pages.clear();
        pages.pages.addAll(list);
    }
}

