/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fzzyhmstrs.emi_loot.EMILootExpectPlatform;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMILoot {
    public static final String MOD_ID = "emi_loot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"emi_loot");
    public static RandomSource emiLootRandom = new SingleThreadedRandomSource(System.currentTimeMillis());
    public static LootTableParser parser = new LootTableParser();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static EmiLootConfig config = EMILoot.readOrCreate();
    public static boolean DEBUG = EMILoot.config.debugMode;
    public static Supplier<LootItemConditionType> WITHER_KILL;
    public static Supplier<LootItemConditionType> SPAWNS_WITH;
    public static Supplier<LootItemConditionType> CREEPER;
    public static Supplier<LootItemFunctionType> SET_ANY_DAMAGE;
    public static Supplier<LootItemFunctionType> OMINOUS_BANNER;
    public static Enchantment RANDOM;

    public static void init() {
    }

    private static EmiLootConfig readOrCreate() {
        File dir = EMILootExpectPlatform.getConfigDir().toFile();
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.error("EMI Loot could not find or create config directory, using default configs");
            return new EmiLootConfig();
        }
        String f_old_name = "EmiLootConfig.json";
        String f_name = "EmiLootConfig_v1.json";
        File f_old = new File(dir, f_old_name);
        try {
            if (f_old.exists()) {
                EmiLootConfigOld oldConfig = (EmiLootConfigOld)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f_old)), EmiLootConfigOld.class);
                EmiLootConfig newConfig = oldConfig.generateNewConfig();
                File f = new File(dir, f_name);
                if (f.exists()) {
                    f_old.delete();
                    return (EmiLootConfig)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f)), EmiLootConfig.class);
                }
                if (!f.createNewFile()) {
                    LOGGER.error("Failed to create new config file, using old config with new defaults.");
                } else {
                    f_old.delete();
                    FileWriter fw = new FileWriter(f);
                    String json = gson.toJson((Object)newConfig);
                    if (DEBUG) {
                        LOGGER.info(json);
                    }
                    fw.write(json);
                    fw.close();
                }
                return newConfig;
            }
            File f = new File(dir, f_name);
            if (f.exists()) {
                return (EmiLootConfig)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f)), EmiLootConfig.class);
            }
            if (!f.createNewFile()) {
                throw new UnsupportedOperationException("couldn't generate config file");
            }
            FileWriter fw = new FileWriter(f);
            EmiLootConfig emc = new EmiLootConfig();
            String json = gson.toJson((Object)emc);
            if (DEBUG) {
                LOGGER.info(json);
            }
            fw.write(json);
            fw.close();
            return emc;
        }
        catch (Exception e) {
            LOGGER.error("Emi Loot failed to create or read it's config file!");
            LOGGER.error(Arrays.toString(e.getStackTrace()));
            return new EmiLootConfig();
        }
    }

    static {
        RANDOM = new Enchantment(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.TRIDENT, EquipmentSlot.values()){

            public boolean m_6594_() {
                return false;
            }

            public boolean m_6592_() {
                return false;
            }
        };
    }

    public static class EmiLootConfig {
        public boolean debugMode = false;
        public boolean parseChestLoot = true;
        public boolean parseBlockLoot = true;
        public boolean parseMobLoot = true;
        public boolean parseGameplayLoot = true;
        public boolean chestLootCompact = true;
        public boolean chestLootAlwaysStackSame = false;
        public boolean mobLootIncludeDirectDrops = true;
        public boolean parseArchaeologyLoot = true;
    }

    public static class EmiLootConfigOld {
        public boolean parseChestLoot = true;
        public boolean parseBlockLoot = true;
        public boolean parseMobLoot = true;
        public boolean parseGameplayLoot = true;

        public EmiLootConfig generateNewConfig() {
            EmiLootConfig newConfig = new EmiLootConfig();
            newConfig.parseChestLoot = this.parseChestLoot;
            newConfig.parseBlockLoot = this.parseBlockLoot;
            newConfig.parseMobLoot = this.parseMobLoot;
            newConfig.parseGameplayLoot = this.parseGameplayLoot;
            return newConfig;
        }
    }
}

