/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.client.AbstractTextKeyParsingClientLootTable;
import fzzyhmstrs.emi_loot.client.ClientRawPool;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ClientGameplayLootTable
extends AbstractTextKeyParsingClientLootTable<ClientGameplayLootTable> {
    public static ClientGameplayLootTable INSTANCE = new ClientGameplayLootTable();
    private static final ResourceLocation EMPTY = new ResourceLocation("blocks/empty");
    public final ResourceLocation id;
    public final ResourceLocation blockId;

    public ClientGameplayLootTable() {
        this.id = EMPTY;
        this.blockId = new ResourceLocation("air");
    }

    public ClientGameplayLootTable(ResourceLocation id, Map<List<TextKey>, ClientRawPool> map) {
        super(map);
        this.id = id;
        String ns = id.m_135827_();
        String pth = id.m_135815_();
        int lastSlashIndex = pth.lastIndexOf(47);
        this.blockId = lastSlashIndex == -1 ? new ResourceLocation(ns, pth) : new ResourceLocation(ns, pth.substring(Math.min(lastSlashIndex + 1, pth.length())));
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public boolean isEmpty() {
        return Objects.equals(this.id, EMPTY);
    }

    @Override
    List<Tuple<Integer, Component>> getSpecialTextKeyList(Level world, Block block) {
        String type;
        String keyString;
        int keyIndex;
        String tool = "";
        if (block.m_204297_().m_203656_(BlockTags.f_144282_)) {
            tool = "pickaxe";
        } else if (block.m_204297_().m_203656_(BlockTags.f_144280_)) {
            tool = "axe";
        } else if (block.m_204297_().m_203656_(BlockTags.f_144283_)) {
            tool = "shovel";
        } else if (block.m_204297_().m_203656_(BlockTags.f_144281_)) {
            tool = "hoe";
        }
        LinkedList<Tuple<Integer, Component>> toolNeededList = new LinkedList<Tuple<Integer, Component>>();
        if (!Objects.equals(tool, "") && (keyIndex = TextKey.getIndex(keyString = "emi_loot." + tool + "." + (type = block.m_204297_().m_203656_(BlockTags.f_144286_) ? "stone" : (block.m_204297_().m_203656_(BlockTags.f_144285_) ? "iron" : (block.m_204297_().m_203656_(BlockTags.f_144284_) ? "diamond" : "wood"))))) != -1) {
            toolNeededList.add((Tuple<Integer, Component>)new Tuple((Object)keyIndex, (Object)LText.translatable(keyString)));
        }
        return toolNeededList;
    }

    @Override
    Tuple<ResourceLocation, ResourceLocation> getBufId(FriendlyByteBuf buf) {
        return new Tuple((Object)ClientGameplayLootTable.getIdFromBuf(buf), (Object)EMPTY);
    }

    @Override
    ClientGameplayLootTable simpleTableToReturn(Tuple<ResourceLocation, ResourceLocation> ids, FriendlyByteBuf buf) {
        ClientRawPool simplePool = new ClientRawPool(new HashMap<List<TextKey>, Object2FloatMap<ItemStack>>());
        Object2FloatOpenHashMap simpleMap = new Object2FloatOpenHashMap();
        ItemStack simpleStack = new ItemStack((ItemLike)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_));
        simpleMap.put((Object)simpleStack, 100.0f);
        simplePool.map().put(new ArrayList(), (Object2FloatMap<ItemStack>)simpleMap);
        HashMap<List<TextKey>, ClientRawPool> itemMap = new HashMap<List<TextKey>, ClientRawPool>();
        itemMap.put(new ArrayList(), simplePool);
        return new ClientGameplayLootTable((ResourceLocation)ids.m_14418_(), itemMap);
    }

    @Override
    ClientGameplayLootTable emptyTableToReturn() {
        return new ClientGameplayLootTable();
    }

    @Override
    ClientGameplayLootTable filledTableToReturn(Tuple<ResourceLocation, ResourceLocation> ids, Map<List<TextKey>, ClientRawPool> itemMap) {
        return new ClientGameplayLootTable((ResourceLocation)ids.m_14418_(), itemMap);
    }
}

