/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.EMILootExpectPlatform;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class GameplayLootRecipe
implements EmiRecipe {
    private final ClientGameplayLootTable loot;
    private final List<EmiStack> outputStacks;
    private final Component name;
    private final List<WidgetRowBuilder> rowBuilderList = new LinkedList<WidgetRowBuilder>();

    public GameplayLootRecipe(ClientGameplayLootTable loot) {
        this.loot = loot;
        loot.build((Level)Minecraft.m_91087_().f_91073_, Blocks.f_50016_);
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stackMap().forEach((weight, stacks) -> list.addAll(stacks.getEmiStacks()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
        String key = "emi_loot.gameplay." + loot.id.toString();
        MutableComponent text = LText.translatable(key);
        if (Objects.equals(text.getString(), key)) {
            if (EMILootExpectPlatform.isModLoaded(loot.id.m_135827_())) {
                String modName = EMILootExpectPlatform.getModName(loot.id.m_135827_());
                this.name = LText.translatable("emi_loot.gameplay.unknown_gameplay", modName);
            } else {
                MutableComponent unknown = LText.translatable("emi_loot.gameplay.unknown");
                this.name = LText.translatable("emi_loot.gameplay.unknown_gameplay", unknown.getString());
            }
        } else {
            this.name = text;
        }
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        if (recursive || this.rowBuilderList.isEmpty()) {
            this.rowBuilderList.add(new WidgetRowBuilder(154));
        }
        boolean added = false;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            if (!builder.canAddPool(newPool)) continue;
            builder.addAndTrim(newPool);
            added = true;
            break;
        }
        if (!added) {
            Optional<ClientBuiltPool> opt = this.rowBuilderList.get(this.rowBuilderList.size() - 1).addAndTrim(newPool);
            opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.GAMEPLAY_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation(EMILootClient.MOD_ID, "/" + this.getCategory().id.m_135815_() + "/" + this.loot.id.m_135827_() + "/" + this.loot.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return 154;
    }

    public int getDisplayHeight() {
        return this.rowBuilderList.size() * 29 + 11;
    }

    public void addWidgets(WidgetHolder widgets) {
        int x = 0;
        int y = 0;
        widgets.addText(this.name.m_7532_(), 0, 0, 0x404040, false);
        y += 11;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            for (ClientBuiltPool pool : builder.getPoolList()) {
                IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                widgets.add((Widget)widget);
                x += widget.getWidth() + 6;
            }
            y += 29;
            x = 0;
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

