/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.BlockPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.NbtPredicateParser;
import fzzyhmstrs.emi_loot.parser.StatePredicateParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class BlockPredicateParser {
    public static Component parseBlockPredicate(BlockPredicate predicate) {
        return LText.translatable("emi_loot.block_predicate.base", BlockPredicateParser.parseBlockPredicateInternal(predicate).getString());
    }

    private static Component parseBlockPredicateInternal(BlockPredicate predicate) {
        TagKey<Block> tag = ((BlockPredicateAccessor)predicate).getTag();
        if (tag != null) {
            return LText.translatable("emi_loot.block_predicate.tag", tag.f_203868_().toString());
        }
        Set<Block> blocks = ((BlockPredicateAccessor)predicate).getBlocks();
        if (blocks != null && !blocks.isEmpty()) {
            List<MutableComponent> list = blocks.stream().map(Block::m_49954_).toList();
            return LText.translatable("emi_loot.block_predicate.list_1", ListProcessors.buildOrList(list));
        }
        StatePropertiesPredicate statePredicate = ((BlockPredicateAccessor)predicate).getState();
        if (!statePredicate.equals(StatePropertiesPredicate.f_67658_)) {
            return StatePredicateParser.parseStatePredicate(statePredicate);
        }
        NbtPredicate nbt = ((BlockPredicateAccessor)predicate).getNbt();
        if (!nbt.equals(NbtPredicate.f_57471_)) {
            return NbtPredicateParser.parseNbtPredicate(nbt);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable block predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

