/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.condition;

import fzzyhmstrs.emi_loot.mixins.TimeCheckLootConditionAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.condition.ConditionParser;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class TimeCheckConditionParser
implements ConditionParser {
    @Override
    public List<LootTableParser.LootConditionResult> parseCondition(LootItemCondition condition, ItemStack stack, boolean parentIsAlternative) {
        Long period = ((TimeCheckLootConditionAccessor)condition).getPeriod();
        IntRange value = ((TimeCheckLootConditionAccessor)condition).getValue();
        String processedValue = NumberProcessors.processBoundedIntUnaryOperator(value).getString();
        if (period != null) {
            return Collections.singletonList(new LootTableParser.LootConditionResult(TextKey.of("emi_loot.condition.time_check_period", period.toString(), processedValue)));
        }
        return Collections.singletonList(new LootTableParser.LootConditionResult(TextKey.of("emi_loot.condition.time_check", processedValue)));
    }
}

