/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;

public class IconGroupEmiWidget
extends Widget {
    private final List<IconEmiWidget> icons;
    private final List<SlotWidget> items;
    private final int x;
    private final int y;
    private final int iconsWidth;
    private final int itemsWidth;
    private final int width;
    private final Bounds bounds;

    public IconGroupEmiWidget(int x, int y, ClientBuiltPool pool) {
        this.x = x;
        this.y = y;
        LinkedList<IconEmiWidget> list = new LinkedList<IconEmiWidget>();
        for (int i = 0; i < pool.list().size(); ++i) {
            Tuple<Integer, Component> pair = pool.list().get(i);
            int xOffset = i / 2 * 11;
            int yOffset = i % 2 * 11;
            list.add(new IconEmiWidget(x + xOffset, y + yOffset, (Integer)pair.m_14418_(), (Component)pair.m_14419_()));
        }
        this.icons = list;
        this.iconsWidth = 12 + (this.icons.size() - 1) / 2 * 11;
        this.itemsWidth = 2 + pool.stackMap().size() * 20;
        this.width = this.iconsWidth + this.itemsWidth;
        this.bounds = new Bounds(x, y, this.width, 23);
        LinkedList<SlotWidget> list2 = new LinkedList<SlotWidget>();
        int itemXOffset = this.iconsWidth + 2;
        for (Map.Entry entry : pool.stackMap().float2ObjectEntrySet()) {
            String rounded = FloatTrimmer.trimFloatString(((Float)entry.getKey()).floatValue());
            SlotWidget widget = new SlotWidget((EmiIngredient)entry.getValue(), itemXOffset + x, y + 3).appendTooltip((Component)LText.translatable("emi_loot.percent_chance", rounded));
            itemXOffset += 20;
            list2.add(widget);
        }
        this.items = list2;
    }

    public int getIconsWidth() {
        return this.iconsWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        for (IconEmiWidget icon : this.icons) {
            if (!icon.getBounds().contains(mouseX, mouseY)) continue;
            return icon.getTooltip(mouseX, mouseY);
        }
        for (SlotWidget slot : this.items) {
            if (!slot.getBounds().contains(mouseX, mouseY)) continue;
            return slot.getTooltip(mouseX, mouseY);
        }
        return List.of();
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        for (SlotWidget slot : this.items) {
            if (!slot.getBounds().contains(mouseX, mouseY) || !slot.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void m_88315_(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        int newWidth;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int widthRemaining = this.itemsWidth;
        int xNew = this.x + this.iconsWidth;
        do {
            newWidth = Math.min(64, widthRemaining);
            draw.m_280411_(IconEmiWidget.FRAME_ID, xNew, this.y, newWidth, 1, 0.0f, 0.0f, newWidth, 1, 64, 16);
            xNew += newWidth;
        } while ((widthRemaining -= newWidth) > 0);
        draw.m_285944_(RenderType.m_285907_(), this.x, this.x + this.width, this.y, this.y + 1, 0x555555);
        for (IconEmiWidget icon : this.icons) {
            icon.m_88315_(draw, mouseX, mouseY, delta);
        }
        for (SlotWidget slot : this.items) {
            slot.m_88315_(draw, mouseX, mouseY, delta);
        }
    }
}

