/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.framingtemplates.item;

import java.util.List;
import ky.someone.mods.framingtemplates.util.DrawerSide;
import ky.someone.mods.framingtemplates.util.FramingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public abstract class FramingTemplateItem
extends Item {
    public static final String DECORATIONS_KEY = "decorations";
    private static final Component NO_DECO = Component.m_237113_((String)"\u2718").m_130938_(FramingUtil.TOOLTIP_RED);
    public final String mod;

    public FramingTemplateItem(String modid) {
        super(new Item.Properties().m_41487_(16));
        this.mod = modid;
    }

    public abstract boolean applyTemplateInWorld(ItemStack var1, Level var2, BlockPos var3, BlockState var4);

    public abstract ItemStack applyTemplateToItem(ItemStack var1, ItemStack var2);

    public ItemStack getDecoration(DrawerSide side, ItemStack stack) {
        CompoundTag decorations = stack.m_41737_(DECORATIONS_KEY);
        if (decorations == null || !decorations.m_128441_(side.key())) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)decorations.m_128469_(side.key()));
    }

    public ItemStack setDecoration(DrawerSide side, ItemStack stack, ItemStack decoration) {
        CompoundTag decorations = stack.m_41698_(DECORATIONS_KEY);
        if (!decoration.m_41619_()) {
            CompoundTag compound = decoration.m_41739_(new CompoundTag());
            decorations.m_128365_(side.key(), (Tag)compound);
        } else {
            decorations.m_128473_(side.key());
        }
        if (decorations.m_128456_()) {
            stack.m_41749_(DECORATIONS_KEY);
        }
        return stack;
    }

    public abstract DrawerSide[] getAllSides();

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Level level;
        ItemStack stack = ctx.m_43722_();
        boolean result = this.applyTemplateInWorld(stack, level = ctx.m_43725_(), pos = ctx.m_8083_(), level.m_8055_(pos));
        if (result) {
            if (!level.f_46443_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean isShift = Screen.m_96638_();
        tooltip.add((Component)Component.m_237115_((String)"tooltip.framing_templates.applied_decorations").m_7220_((Component)Component.m_237113_((String)" (Shift)").m_130940_(isShift ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY)).m_130938_(FramingUtil.TOOLTIP_BLUE));
        if (isShift) {
            for (DrawerSide side : this.getAllSides()) {
                MutableComponent component = Component.m_237113_((String)(" " + side.symbol() + " ")).m_7220_((Component)Component.m_237115_((String)"tooltip.framing_templates.sides.%s".formatted(side.key())).m_130938_(FramingUtil.TOOLTIP_EXTRA)).m_130946_(": ").m_130938_(FramingUtil.TOOLTIP_FLAVOUR);
                ItemStack item = this.getDecoration(side, stack);
                if (!item.m_41619_()) {
                    component.m_7220_((Component)item.m_41786_().m_6881_().m_130938_(FramingUtil.TOOLTIP_MAIN));
                } else {
                    component.m_7220_(NO_DECO);
                }
                tooltip.add((Component)component);
            }
        }
        String mod = ((ModContainer)ModList.get().getModContainerById(this.mod).orElseThrow()).getModInfo().getDisplayName();
        tooltip.add((Component)Component.m_237110_((String)"tooltip.framing_templates.applicable_to", (Object[])new Object[]{Component.m_237113_((String)mod).m_130938_(FramingUtil.TOOLTIP_MAIN)}).m_130938_(FramingUtil.TOOLTIP_GREEN));
    }
}

