/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.framingtemplates.item;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import eutros.framedcompactdrawers.block.ModBlocks;
import eutros.framedcompactdrawers.block.tile.IFramingHolder;
import eutros.framedcompactdrawers.item.ItemDrawersCustom;
import eutros.framedcompactdrawers.item.ItemOtherCustom;
import ky.someone.mods.framingtemplates.item.FramingTemplateItem;
import ky.someone.mods.framingtemplates.util.DrawerSide;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class StorageDrawersTemplate
extends FramingTemplateItem {
    public static final DrawerSide FRONT = DrawerSide.of("front", -1, 0, '\u2b05');
    public static final DrawerSide SIDE = DrawerSide.of("side", -1, -1, '\u2b09');
    public static final DrawerSide TRIM = DrawerSide.of("trim", 0, -1, '\u2b06');

    public StorageDrawersTemplate(String modid) {
        super(modid);
    }

    @Override
    public boolean applyTemplateInWorld(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof BaseBlockEntity) {
            BaseBlockEntity base = (BaseBlockEntity)be;
            if (be instanceof IFramingHolder) {
                IFramingHolder frameable = (IFramingHolder)be;
            } else {
                CompoundTag tag = be.m_187482_();
                Block block = this.tryConvertDrawer(state.m_60734_());
                if (block != null && block != state.m_60734_()) {
                    level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    level.m_46597_(pos, block.m_152465_(state));
                    be = level.m_7702_(pos);
                    be.m_142466_(tag);
                }
            }
        }
        if (be instanceof IFramingHolder) {
            IFramingHolder frameable = (IFramingHolder)be;
            frameable.setFront(this.getDecoration(FRONT, stack));
            frameable.setSide(this.getDecoration(SIDE, stack));
            frameable.setTrim(this.getDecoration(TRIM, stack));
            be.requestModelDataUpdate();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack applyTemplateToItem(ItemStack template, ItemStack target) {
        Item item = target.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!(item instanceof ItemDrawersCustom) && !(item instanceof ItemOtherCustom)) {
                Block converted = this.tryConvertDrawer(blockItem.m_40614_());
                if (converted == null) {
                    return target;
                }
                if (!target.m_150930_(converted.m_5456_())) {
                    target = new ItemStack((ItemLike)converted, target.m_41613_(), target.m_41783_());
                }
            }
            CompoundTag tag = target.m_41784_();
            tag.m_128365_("MatF", (Tag)this.getDecoration(FRONT, template).serializeNBT());
            tag.m_128365_("MatS", (Tag)this.getDecoration(SIDE, template).serializeNBT());
            tag.m_128365_("MatT", (Tag)this.getDecoration(TRIM, template).serializeNBT());
        }
        return target;
    }

    @Nullable
    private Block tryConvertDrawer(Block block) {
        if (block instanceof BlockDrawers) {
            BlockDrawers drawers = (BlockDrawers)block;
            return switch (drawers.getDrawerCount()) {
                case 1 -> {
                    if (drawers.isHalfDepth()) {
                        yield ModBlocks.framedHalfOne;
                    }
                    yield ModBlocks.framedFullOne;
                }
                case 2 -> {
                    if (drawers.isHalfDepth()) {
                        yield ModBlocks.framedHalfTwo;
                    }
                    yield ModBlocks.framedFullTwo;
                }
                case 4 -> {
                    if (drawers.isHalfDepth()) {
                        yield ModBlocks.framedHalfFour;
                    }
                    yield ModBlocks.framedFullFour;
                }
                default -> block instanceof BlockCompDrawers ? ModBlocks.framedCompactDrawer : null;
            };
        }
        if (block instanceof BlockTrim) {
            return ModBlocks.framedTrim;
        }
        if (block instanceof BlockController) {
            return ModBlocks.framedDrawerController;
        }
        if (block instanceof BlockSlave) {
            return ModBlocks.framedSlave;
        }
        return null;
    }

    @Override
    public DrawerSide[] getAllSides() {
        return new DrawerSide[]{SIDE, FRONT, TRIM};
    }
}

