/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.command.FTBEssentialsCommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.kit.Kit;
import dev.ftb.mods.ftbessentials.kit.KitManager;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.InventoryUtil;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;

public class KitCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.KIT.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kit").requires(FTBEConfig.KIT.enabledAndOp())).then(Commands.m_82127_((String)"create_from_player_inv").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommands.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", false))).then(Commands.m_82129_((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), false)))))).then(Commands.m_82127_((String)"create_from_player_hotbar").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommands.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", true))).then(Commands.m_82129_((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), true)))))).then(Commands.m_82127_((String)"create_from_block_inv").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommands.createKitFromBlock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), ""))).then(Commands.m_82129_((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.createKitFromBlock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.deleteKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.m_82127_((String)"list").executes(ctx -> KitCommands.listKits((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.showKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.giveKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.m_91477_((CommandContext)ctx, (String)"players"))))))).then(Commands.m_82127_((String)"put_in_block_inv").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.putKitInBlockInv((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.m_82127_((String)"cooldown").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).then(Commands.m_82129_((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> FTBEssentialsCommands.suggestCooldowns(builder)).executes(ctx -> KitCommands.modifyCooldown((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(Commands.m_82127_((String)"reset_cooldown").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).executes(ctx -> KitCommands.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> KitCommands.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))))).then(Commands.m_82129_((String)"id", (ArgumentType)UuidArgument.m_113850_()).executes(ctx -> KitCommands.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), UuidArgument.m_113853_((CommandContext)ctx, (String)"id"))))))).then(Commands.m_82127_((String)"set_autogrant").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommands.suggestKits(builder)).then(Commands.m_82129_((String)"grant", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> KitCommands.modifyAutogrant((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"grant")))))));
        }
    }

    private static int putKitInBlockInv(CommandSourceStack source, String kitName) {
        try {
            ServerPlayer player = source.m_81375_();
            BlockHitResult res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> new IllegalArgumentException("No such kit: " + kitName));
            if (!InventoryUtil.putItemsInInventory(kit.getItems(), player.m_9236_(), res.m_82425_(), res.m_82434_())) {
                throw new RuntimeException("Not enough space");
            }
            source.m_288197_(() -> Component.m_237113_((String)("Added item(s) from kit '" + kitName + "' to focused inventory")).m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Can't store kit in inventory: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static CompletableFuture<Suggestions> suggestKits(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(KitManager.getInstance().allKits().stream().map(Kit::getKitName).toList(), (SuggestionsBuilder)builder);
    }

    private static int createKitFromPlayer(CommandSourceStack source, String name, String cooldown, boolean hotbarOnly) {
        try {
            long secs = DurationInfo.getSeconds(cooldown);
            KitManager.getInstance().createFromPlayerInv(name, source.m_81375_(), secs, hotbarOnly);
            source.m_288197_(() -> Component.m_237113_((String)("Kit '" + name + "' created")).m_130940_(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Can't create kit: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int createKitFromBlock(CommandSourceStack source, String name, String cooldown) {
        try {
            long secs = DurationInfo.getSeconds(cooldown);
            ServerPlayer player = source.m_81375_();
            BlockHitResult res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            KitManager.getInstance().createFromBlockInv(name, player.m_9236_(), res.m_82425_(), res.m_82434_(), secs);
            source.m_288197_(() -> Component.m_237113_((String)("Kit '" + name + "' created")).m_130940_(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Can't create kit: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int giveKit(CommandSourceStack source, String name, Collection<ServerPlayer> players) {
        try {
            players.forEach(player -> KitManager.getInstance().giveKitToPlayer(name, (ServerPlayer)player));
            source.m_288197_(() -> Component.m_237113_((String)("Kit '" + name + "' given to " + players.size() + " player(s)")).m_130940_(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Can't give kit to player: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int listKits(CommandSourceStack source) {
        Collection<Kit> kits = KitManager.getInstance().allKits();
        source.m_288197_(() -> Component.m_237113_((String)(kits.size() + " kit(s)")).m_130940_(ChatFormatting.AQUA), false);
        kits.stream().sorted(Comparator.comparing(Kit::getKitName)).forEach(kit -> source.m_288197_(() -> Component.m_237113_((String)("\u2022 " + kit.getKitName())).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kit show " + kit.getKitName()))), false));
        return 1;
    }

    private static int showKit(CommandSourceStack source, String kitName) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            source.m_288197_(() -> Component.m_237113_((String)Strings.repeat((char)'-', (int)40)).m_130940_(ChatFormatting.GREEN), false);
            source.m_288197_(() -> Component.m_237113_((String)"Kit Name: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)kit.getKitName()).m_130940_(ChatFormatting.YELLOW)), false);
            if (kit.getCooldown() > 0L) {
                source.m_288197_(() -> Component.m_237113_((String)"  Cooldown: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)TimeUtils.prettyTimeString((long)kit.getCooldown())).m_130940_(ChatFormatting.YELLOW)), false);
            } else if (kit.getCooldown() == 0L) {
                source.m_288197_(() -> Component.m_237113_((String)"  No Cooldown").m_130940_(ChatFormatting.AQUA), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"  One-Time Use").m_130940_(ChatFormatting.AQUA), false);
            }
            if (kit.isAutoGrant()) {
                source.m_288197_(() -> Component.m_237113_((String)"  Autogranted on player login").m_130940_(ChatFormatting.AQUA), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)"  Items:").m_130940_(ChatFormatting.AQUA), false);
            for (ItemStack stack : kit.getItems()) {
                source.m_288197_(() -> Component.m_237113_((String)"  \u2022 ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(stack.m_41613_() + " x ")).m_130940_(ChatFormatting.WHITE)).m_7220_(stack.m_41611_()), false);
            }
        }, () -> source.m_81352_((Component)Component.m_237113_((String)("No such kit: " + kitName)).m_130940_(ChatFormatting.RED)));
        return 1;
    }

    private static int deleteKit(CommandSourceStack source, String kitName) {
        try {
            KitManager.getInstance().deleteKit(kitName);
            source.m_288197_(() -> Component.m_237113_((String)("Kit '" + kitName + "' deleted")).m_130940_(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Can't delete kit '" + kitName + "': " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int modifyAutogrant(CommandSourceStack source, String kitName, boolean grant) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            KitManager.getInstance().addKit(kit.withAutoGrant(grant), true);
            source.m_288197_(() -> Component.m_237113_((String)("Kit '" + kitName + "' autogrant modified: " + grant)).m_130940_(ChatFormatting.YELLOW), false);
        }, () -> source.m_81352_((Component)Component.m_237113_((String)("No such kit: " + kitName)).m_130940_(ChatFormatting.RED)));
        return 1;
    }

    private static int modifyCooldown(CommandSourceStack source, String kitName, String cooldown) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            long secs = DurationInfo.getSeconds(cooldown);
            KitManager.getInstance().addKit(kit.withCooldown(secs), true);
            String newTime = secs < 0L ? "One-Time Use" : TimeUtils.prettyTimeString((long)secs);
            source.m_288197_(() -> Component.m_237113_((String)("Kit '" + kitName + "' cooldown modified: " + newTime)).m_130940_(ChatFormatting.YELLOW), false);
        }, () -> source.m_81352_((Component)Component.m_237113_((String)("No such kit: " + kitName)).m_130940_(ChatFormatting.RED)));
        return 1;
    }

    private static int resetCooldowns(CommandSourceStack source, String name, ServerPlayer player) {
        return KitCommands.resetCooldowns(source, name, player.m_20148_());
    }

    private static int resetCooldowns(CommandSourceStack source, String name, UUID playerId) {
        if (KitManager.getInstance().get(name).isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown kit: " + name)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!FTBEPlayerData.playerExists(playerId)) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown player ID: " + playerId)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        FTBEPlayerData.getOrCreate(new GameProfile(playerId, "")).ifPresent(data -> {
            data.setLastKitUseTime(name, 0L);
            source.m_288197_(() -> Component.m_237113_((String)("Cooldown for '" + name + "' reset for UUID " + playerId)).m_130940_(ChatFormatting.YELLOW), false);
        });
        return 1;
    }

    private static int resetCooldowns(CommandSourceStack source, String name) {
        if (KitManager.getInstance().get(name).isPresent()) {
            FTBEPlayerData.cleanupKitCooldowns(name);
            source.m_288197_(() -> Component.m_237113_((String)("Cooldown for '" + name + "' reset for all players")).m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Unknown kit: " + name)).m_130940_(ChatFormatting.RED));
        return 0;
    }
}

