/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr;

import argent_matter.gcyr.GCYRClient;
import argent_matter.gcyr.api.gui.factory.EntityUIFactory;
import argent_matter.gcyr.api.registries.GCYRRegistries;
import argent_matter.gcyr.common.data.GCYRBlocks;
import argent_matter.gcyr.common.data.GCYRCreativeModeTabs;
import argent_matter.gcyr.common.data.GCYRDimensionMarkers;
import argent_matter.gcyr.common.data.GCYRDimensionTypes;
import argent_matter.gcyr.common.data.GCYREntities;
import argent_matter.gcyr.common.data.GCYREntityDataSerializers;
import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.common.data.GCYRMachines;
import argent_matter.gcyr.common.data.GCYRMaterials;
import argent_matter.gcyr.common.data.GCYRMenus;
import argent_matter.gcyr.common.data.GCYRNetworking;
import argent_matter.gcyr.common.data.GCYRParticles;
import argent_matter.gcyr.common.data.GCYRRecipeConditions;
import argent_matter.gcyr.common.data.GCYRRecipeTypes;
import argent_matter.gcyr.common.data.GCYRSatellites;
import argent_matter.gcyr.common.data.GCYRVanillaRecipeTypes;
import argent_matter.gcyr.common.gui.EntityOxygenHUD;
import argent_matter.gcyr.config.GCYRConfig;
import argent_matter.gcyr.data.GCYRDatagen;
import argent_matter.gcyr.data.loader.PlanetResources;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialRegistryEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.PostMaterialEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.lowdragmc.lowdraglib.gui.factory.UIFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="gcyr")
public class GCYR {
    public static final String MOD_ID = "gcyr";
    public static final String NAME = "Gregicality Rocketry";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Gregicality Rocketry");
    public static MaterialRegistry MATERIAL_REGISTRY;

    public GCYR() {
        GCYR.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        bus.addGenericListener(GTRecipeType.class, this::registerRecipeTypes);
        bus.addGenericListener(Class.class, this::registerRecipeConditions);
        bus.addGenericListener(MachineDefinition.class, this::registerMachines);
        bus.addGenericListener(DimensionMarker.class, this::registerDimensionMarkers);
        GCYRDimensionTypes.register(bus);
        GCYRVanillaRecipeTypes.RECIPE_TYPE_DEFERRED_REGISTER.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> GCYRClient::init);
    }

    public static void init() {
        GCYRConfig.init();
        GCYRNetworking.init();
        UIFactory.register((UIFactory)EntityUIFactory.INSTANCE);
        GCYRSatellites.init();
        GCYREntityDataSerializers.init();
        GCYRCreativeModeTabs.init();
        GCYREntities.init();
        GCYRBlocks.init();
        GCYRItems.init();
        GCYRMenus.init();
        GCYRDatagen.init();
        GCYRRegistries.REGISTRATE.registerRegistrate();
        GCYRDimensionTypes.init();
        GCYRParticles.init();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @SubscribeEvent
    public void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("oxygen_tank", (IGuiOverlay)new EntityOxygenHUD());
    }

    @SubscribeEvent
    public void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)PlanetResources.INSTANCE);
    }

    @SubscribeEvent
    public void registerMaterialRegistry(MaterialRegistryEvent event) {
        MATERIAL_REGISTRY = GTCEuAPI.materialManager.createRegistry(MOD_ID);
    }

    @SubscribeEvent
    public void registerMaterials(MaterialEvent event) {
        GCYRMaterials.init();
    }

    @SubscribeEvent
    public void modifyMaterials(PostMaterialEvent event) {
        GCYRMaterials.modifyMaterials();
    }

    public void registerRecipeTypes(GTCEuAPI.RegisterEvent<ResourceLocation, GTRecipeType> event) {
        GCYRRecipeTypes.init();
    }

    public void registerRecipeConditions(GTCEuAPI.RegisterEvent<String, Class<? extends RecipeCondition>> event) {
        GCYRRecipeConditions.init();
    }

    public void registerMachines(GTCEuAPI.RegisterEvent<ResourceLocation, MachineDefinition> event) {
        GCYRMachines.init();
    }

    public void registerDimensionMarkers(GTCEuAPI.RegisterEvent<ResourceLocation, DimensionMarker> event) {
        GCYRDimensionMarkers.init();
    }
}

