/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.capability;

import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.api.space.station.SpaceStation;
import argent_matter.gcyr.util.Vec2i;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ISpaceStationHolder {
    public Int2ObjectMap<SpaceStation> getStations();

    public int getClosestStationId(Vec2i var1);

    @Nullable
    public Vec2i getStationPos(int var1);

    @Nullable
    public SpaceStation getStation(@Nullable Integer var1);

    @Nullable
    public BlockPos getStationWorldPos(int var1);

    public List<Integer> getStationsNearPos(Vec2i var1, int var2);

    default public List<Integer> getStationsNearWorldPos(BlockPos pos, int range) {
        return this.getStationsNearPos(new Vec2i(pos.m_123341_() / SpaceStation.BLOCK_MULTIPLIER, pos.m_123343_() / SpaceStation.BLOCK_MULTIPLIER), range / SpaceStation.BLOCK_MULTIPLIER);
    }

    @Nullable
    default public Pair<Integer, SpaceStation> allocateStation(Planet orbitPlanet) {
        int id = this.getFreeStationId();
        Vec2i pos = this.getFreeStationPos(id);
        if (pos == Vec2i.MAX_NEGATIVE) {
            return null;
        }
        SpaceStation station = new SpaceStation(orbitPlanet, pos);
        return new Pair((Object)id, (Object)station);
    }

    public void addStation(int var1, SpaceStation var2);

    public void destroyStation(int var1);

    public int getFreeStationId();

    public Vec2i getFreeStationPos(int var1);
}

