/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.planet;

import argent_matter.gcyr.data.loader.PlanetData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record Planet(String translation, ResourceLocation galaxy, ResourceLocation solarSystem, ResourceKey<Level> level, ResourceKey<Level> orbitWorld, ResourceKey<Level> parentWorld, int rocketTier, float gravity, boolean hasAtmosphere, int daysInYear, float temperature, long solarPower, boolean hasOxygen, int buttonColor) {
    public static final Codec<Planet> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translation").forGetter(Planet::translation), (App)ResourceLocation.f_135803_.fieldOf("galaxy").forGetter(Planet::galaxy), (App)ResourceLocation.f_135803_.fieldOf("solar_system").forGetter(Planet::solarSystem), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("world").forGetter(Planet::level), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("orbit_world").forGetter(Planet::orbitWorld), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).optionalFieldOf("parent_world").forGetter(Planet::getParentlevel), (App)Codec.INT.fieldOf("rocket_tier").forGetter(Planet::rocketTier), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Planet::gravity), (App)Codec.BOOL.fieldOf("has_atmosphere").forGetter(Planet::hasAtmosphere), (App)Codec.INT.fieldOf("days_in_year").forGetter(Planet::daysInYear), (App)Codec.FLOAT.fieldOf("temperature").forGetter(Planet::temperature), (App)Codec.LONG.fieldOf("solar_power").forGetter(Planet::solarPower), (App)Codec.BOOL.fieldOf("has_oxygen").forGetter(Planet::hasOxygen), (App)Codec.INT.fieldOf("button_color").forGetter(Planet::buttonColor)).apply((Applicative)instance, Planet::new));
    public static final Codec<Planet> ID_CODEC = ResourceLocation.f_135803_.flatXmap(rl -> Optional.ofNullable(PlanetData.getPlanet(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No Planet with id " + rl + " registered")), obj -> Optional.ofNullable(PlanetData.getPlanetId(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Planet " + obj + " not registered")));
    public static final Codec<Planet> CODEC = Codec.either(ID_CODEC, DIRECT_CODEC).xmap(either -> (Planet)either.map(Function.identity(), Function.identity()), Either::left);

    public Planet(String translation, ResourceLocation galaxy, ResourceLocation solarSystem, ResourceKey<Level> level, ResourceKey<Level> orbitWorld, Optional<ResourceKey<Level>> parentWorld, int rocketTier, float gravity, boolean hasAtmosphere, int daysInYear, float temperature, long solarPower, boolean hasOxygen, int buttonColor) {
        this(translation, galaxy, solarSystem, level, orbitWorld, (ResourceKey<Level>)((ResourceKey)parentWorld.orElse(null)), rocketTier, gravity, hasAtmosphere, daysInYear, temperature, solarPower, hasOxygen, buttonColor);
    }

    private Optional<ResourceKey<Level>> getParentlevel() {
        return Optional.ofNullable(this.parentWorld);
    }
}

