/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.satellite.capability;

import argent_matter.gcyr.api.capability.ISatelliteHolder;
import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.util.Vec2i;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class SatelliteWorldSavedData
extends SavedData
implements ISatelliteHolder {
    private final List<Satellite> satellites = new ArrayList<Satellite>();
    private final ServerLevel level;

    @Nullable
    public static SatelliteWorldSavedData getOrCreate(ServerLevel serverLevel) {
        if (serverLevel.m_6042_().f_63856_()) {
            return null;
        }
        return (SatelliteWorldSavedData)serverLevel.m_8895_().m_164861_(tag -> new SatelliteWorldSavedData(serverLevel, (CompoundTag)tag), () -> new SatelliteWorldSavedData(serverLevel), "gcyr_satellites");
    }

    public SatelliteWorldSavedData(ServerLevel level) {
        this.level = level;
    }

    public SatelliteWorldSavedData(ServerLevel level, CompoundTag tag) {
        this.level = level;
        this.load(tag);
    }

    @Override
    public void tickSatellites() {
        this.getSatellites().forEach(satellite -> satellite.tickSatellite((Level)this.level));
    }

    @Override
    public Satellite getClosestSatellite(Vec2i position) {
        return this.satellites.stream().min(Comparator.comparingDouble(obj -> obj.getData().locationInWorld().distanceToSqr(position))).orElse(null);
    }

    @Override
    @Nullable
    public List<Satellite> getSatellitesNearPos(Vec2i position, int range) {
        return this.satellites.stream().filter(sat -> sat.getData().locationInWorld().distanceToSqr(position) <= range * range).sorted(Comparator.comparingDouble(sat -> sat.getData().locationInWorld().distanceToSqr(position))).collect(Collectors.toList());
    }

    @Override
    public void addSatellite(@Nullable Satellite satellite) {
        if (satellite != null) {
            this.satellites.add(satellite);
        }
    }

    @Override
    public void destroySatellite(Satellite satellite) {
        this.satellites.remove(satellite);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag tag = new ListTag();
        for (Satellite satellite : this.satellites) {
            tag.add((Object)satellite.serializeNBT());
        }
        compoundTag.m_128365_("satellites", (Tag)tag);
        return compoundTag;
    }

    public void load(CompoundTag compoundTag) {
        for (Tag tag : compoundTag.m_128437_("satellites", 10)) {
            this.satellites.add(Satellite.deserializeNBT((CompoundTag)tag, (Level)this.level));
        }
    }

    @Override
    public List<Satellite> getSatellites() {
        return this.satellites;
    }
}

