/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.client.dimension.renderer;

import argent_matter.gcyr.api.space.planet.PlanetSkyRenderer;
import argent_matter.gcyr.client.dimension.renderer.DimensionRenderer;
import argent_matter.gcyr.client.dimension.renderer.ModSkyRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class DimensionEffects
extends DimensionSpecialEffects
implements DimensionRenderer {
    private final PlanetSkyRenderer renderer;
    private final ModSkyRenderer skyRenderer;

    public DimensionEffects(PlanetSkyRenderer renderer) {
        super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        this.renderer = renderer;
        this.skyRenderer = new ModSkyRenderer(renderer);
    }

    public Vec3 m_5927_(Vec3 color, float sunHeight) {
        if (this.renderer.effects().type().equals((Object)PlanetSkyRenderer.DimensionEffectType.COLORED_HORIZON)) {
            int colour = this.renderer.effects().colour();
            return new Vec3((double)((float)(colour >> 16 & 0xFF) / 255.0f), (double)((float)(colour >> 8 & 0xFF) / 255.0f), (double)((float)(colour & 0xFF) / 255.0f));
        }
        return color.m_82542_((double)(sunHeight * 0.94f + 0.06f), (double)(sunHeight * 0.94f + 0.06f), (double)(sunHeight * 0.91f + 0.09f));
    }

    public boolean m_5781_(int camX, int camY) {
        return this.renderer.effects().type().isFoggy();
    }

    public float[] m_7518_(float skyAngle, float tickDelta) {
        PlanetSkyRenderer.DimensionEffectType type = this.renderer.effects().type();
        if (type == PlanetSkyRenderer.DimensionEffectType.FOGGY_REVERSED || type == PlanetSkyRenderer.DimensionEffectType.NONE) {
            return null;
        }
        return super.m_7518_(skyAngle, tickDelta);
    }

    @Override
    public boolean renderClouds(ClientLevel level, int ticks, float tickDelta, PoseStack poseStack, double cameraX, double cameraY, double cameraZ, Matrix4f projectionMatrix) {
        return switch (this.renderer.cloudEffects()) {
            default -> throw new IncompatibleClassChangeError();
            case PlanetSkyRenderer.CloudEffects.NONE -> true;
            case PlanetSkyRenderer.CloudEffects.VANILLA -> false;
        };
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.renderer.cloudEffects() != PlanetSkyRenderer.CloudEffects.VANILLA;
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float tickDelta, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean foggy, Runnable setupFog) {
        setupFog.run();
        this.skyRenderer.render(level, ticks, tickDelta, poseStack, camera, projectionMatrix, foggy);
        return true;
    }

    @Override
    public boolean shouldRenderSky() {
        return true;
    }

    @Override
    public boolean renderSnowAndRain(ClientLevel level, int ticks, float tickDelta, LightTexture manager, double cameraX, double cameraY, double cameraZ) {
        return switch (this.renderer.weatherEffects()) {
            default -> throw new IncompatibleClassChangeError();
            case PlanetSkyRenderer.WeatherEffects.NONE -> true;
            case PlanetSkyRenderer.WeatherEffects.VANILLA -> false;
        };
    }

    @Override
    public boolean shouldRenderSnowAndRain() {
        return this.renderer.weatherEffects() != PlanetSkyRenderer.WeatherEffects.VANILLA;
    }

    public PlanetSkyRenderer getRenderer() {
        return this.renderer;
    }
}

