/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.client.dimension.renderer;

import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.Util;
import org.joml.Vector3f;

public class StarInformation {
    public static final int BASE_COLOUR = -1;
    public static final int[] STAR_COLOURS = new int[]{-1, -3346689, -3368449, -26113, -13210};
    public static final BiFunction<Long, Integer, StarInformation> STAR_CACHE = Util.m_143821_(StarInformation::new);
    private final Vector3f[] param1;
    private final float[] multiplier;
    private final float[] randomPi;
    private final int[][] colour;

    public StarInformation(long seed, int stars) {
        this.param1 = new Vector3f[stars];
        this.multiplier = new float[stars];
        this.randomPi = new float[stars];
        this.colour = new int[stars][4];
        Random random = new Random(seed);
        for (int i = 0; i < stars; ++i) {
            float d = random.nextFloat() * 2.0f - 1.0f;
            float e = random.nextFloat() * 2.0f - 1.0f;
            float f = random.nextFloat() * 2.0f - 1.0f;
            this.param1[i] = new Vector3f(d, e, f);
            this.multiplier[i] = 0.15f + random.nextFloat() * 0.01f;
            this.randomPi[i] = random.nextFloat() * ((float)Math.PI * 2);
            for (int j = 0; j < 4; ++j) {
                this.colour[i][j] = STAR_COLOURS[random.nextInt(STAR_COLOURS.length)];
            }
        }
    }

    public Vector3f getParam1(int i) {
        return this.param1[i];
    }

    public float getMultiplier(int i) {
        return this.multiplier[i];
    }

    public float getRandomPi(int i) {
        return this.randomPi[i];
    }

    public int getColour(int i, int j, boolean coloured) {
        return coloured ? this.colour[i][j] : -1;
    }
}

