/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.client.gui.widget;

import argent_matter.gcyr.client.gui.texture.SatelliteProspectingTexture;
import argent_matter.gcyr.common.machine.electric.OreFinderScannerMachine;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.common.item.ProspectorScannerBehavior;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SatelliteScanWidget
extends WidgetGroup {
    private final int chunkRadius;
    private final int scanTick;
    public final OreFinderScannerMachine machine;
    private boolean darkMode = false;
    @OnlyIn(value=Dist.CLIENT)
    private SatelliteProspectingTexture texture;
    private int playerChunkX;
    private int playerChunkZ;
    private int chunkIndex = 0;
    private final Queue<Pair<BlockState[][][], ChunkPos>> packetQueue = new LinkedBlockingQueue<Pair<BlockState[][][], ChunkPos>>();
    private final Set<Object> items = new CopyOnWriteArraySet<Object>();
    private final Map<String, SelectableWidgetGroup> selectedMap = new ConcurrentHashMap<String, SelectableWidgetGroup>();

    public SatelliteScanWidget(int xPosition, int yPosition, int width, int height, int chunkRadius, int scanTick, OreFinderScannerMachine machine) {
        super(xPosition, yPosition, width, height);
        this.chunkRadius = chunkRadius;
        this.scanTick = scanTick;
        this.machine = machine;
        int imageWidth = (chunkRadius * 2 - 1) * 16;
        int imageHeight = (chunkRadius * 2 - 1) * 16;
        this.addWidget((Widget)new ImageWidget(0, (height - imageHeight) / 2 - 4, imageWidth + 8, imageHeight + 8, (IGuiTexture)GuiTextures.BACKGROUND_INVERSE));
        WidgetGroup group = (WidgetGroup)new WidgetGroup(imageWidth + 10, 0, width - (imageWidth + 10), height).setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        this.addWidget((Widget)group);
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        this.playerChunkX = this.gui.entityPlayer.m_146902_().f_45578_;
        buffer.m_130130_(this.playerChunkX);
        this.playerChunkZ = this.gui.entityPlayer.m_146902_().f_45579_;
        buffer.m_130130_(this.playerChunkZ);
        buffer.m_130130_(this.gui.entityPlayer.m_146903_());
        buffer.m_130130_(this.gui.entityPlayer.m_146907_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.texture = new SatelliteProspectingTexture(buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), this.gui.entityPlayer.m_213816_(), this.chunkRadius, this.darkMode, this.machine::getItemColor);
    }

    public void setDarkMode(boolean mode) {
        if (this.darkMode != mode) {
            this.darkMode = mode;
            if (this.isRemote()) {
                this.texture.setDarkMode(this.darkMode);
            }
        }
    }

    private void addOresToList(Object[][][] data) {
        HashSet<Object> newItems = new HashSet<Object>();
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                newItems.addAll(Arrays.asList(data[x][z]));
            }
        }
        this.items.addAll(newItems);
    }

    public void detectAndSendChanges() {
        ItemStack held;
        Object object;
        Player player = this.gui.entityPlayer;
        Level world = player.m_9236_();
        if (this.gui.getTickCount() % (long)this.scanTick == 0L && this.chunkIndex < (this.chunkRadius * 2 - 1) * (this.chunkRadius * 2 - 1)) {
            int row = this.chunkIndex / (this.chunkRadius * 2 - 1);
            int column = this.chunkIndex % (this.chunkRadius * 2 - 1);
            int ox = column - this.chunkRadius + 1;
            int oz = row - this.chunkRadius + 1;
            LevelChunk chunk = world.m_6325_(this.playerChunkX + ox, this.playerChunkZ + oz);
            BlockState[][][] data = new BlockState[32][32][0];
            this.machine.scanOres(data);
            ++this.chunkIndex;
        }
        if ((object = (held = player.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof ComponentItem) {
            ComponentItem componentItem = (ComponentItem)object;
            for (IItemComponent component : componentItem.getComponents()) {
                if (!(component instanceof ProspectorScannerBehavior)) continue;
                ProspectorScannerBehavior prospector = (ProspectorScannerBehavior)component;
                if (player.m_7500_() || prospector.drainEnergy(held, false)) continue;
                player.m_6915_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id != -1) {
            super.readUpdateInfo(id, buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.packetQueue != null) {
            int max = 10;
            while (max-- > 0 && !this.packetQueue.isEmpty()) {
                Pair<BlockState[][][], ChunkPos> packet = this.packetQueue.poll();
                this.texture.updateTexture((BlockState[][][])packet.getFirst(), (ChunkPos)packet.getSecond());
                this.addOresToList((Object[][][])packet.getFirst());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addPacketToQueue(Pair<BlockState[][][], ChunkPos> packet) {
        this.packetQueue.add(packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        int x = position.x + 3;
        int y = position.y + (size.getHeight() - this.texture.getImageHeight()) / 2 - 1;
        this.texture.draw(graphics, x, y);
        int cX = (mouseX - x) / 16;
        int cZ = (mouseY - y) / 16;
        if (cX >= 0 && cZ >= 0 && cX < this.chunkRadius * 2 - 1 && cZ < this.chunkRadius * 2 - 1) {
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(cX * 16 + x), (int)(cZ * 16 + y), (int)16, (int)16, (int)1265396844);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        int x = position.x + 3;
        int y = position.y + (size.getHeight() - this.texture.getImageHeight()) / 2 - 1;
        int cX = (mouseX - x) / 16;
        int cZ = (mouseY - y) / 16;
        if (cX >= 0 && cZ >= 0 && cX < this.chunkRadius * 2 - 1 && cZ < this.chunkRadius * 2 - 1) {
            ArrayList tooltips = new ArrayList();
            this.gui.getModularUIGui().setHoverTooltip(tooltips, ItemStack.f_41583_, null, null);
        }
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }
}

