/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.data;

import argent_matter.gcyr.GCYR;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlag;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttributes;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import java.util.Collection;

public class GCYRMaterials {
    public static final Material PotassiumChloride = new Material.Builder(GCYR.id("potassium_chloride")).dust(1).color(16183726).components(new Object[]{GTMaterials.Potassium, 1, GTMaterials.Chlorine, 1}).buildAndRegister();
    public static final Material Bisalloy400 = new Material.Builder(GCYR.id("bisalloy_400")).ingot(5).fluid().color(829465).components(new Object[]{GTMaterials.Carbon, 3, GTMaterials.Manganese, 4, GTMaterials.Silicon, 2, GTMaterials.Chromium, 3, GTMaterials.Molybdenum, 1, GTMaterials.Iron, 11}).flags(new MaterialFlag[]{MaterialFlags.GENERATE_PLATE, MaterialFlags.GENERATE_ROD, MaterialFlags.GENERATE_LONG_ROD, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_FRAME}).toolStats(ToolProperty.Builder.of((float)70.0f, (float)2.25f, (int)1296, (int)5).build()).blastTemp(10800, BlastProperty.GasTier.HIGHER).buildAndRegister();
    public static final Material ChromicAcid = new Material.Builder(GCYR.id("chromic_acid")).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().attribute(FluidAttributes.ACID)).color(15063282).components(new Object[]{GTMaterials.Hydrogen, 2, GTMaterials.Chromium, 1, GTMaterials.Oxygen, 4}).buildAndRegister();
    public static Material Trinaquadalloy = new Material.Builder(GCYR.id("trinaquadalloy")).ingot().fluid().color(2627634).iconSet(MaterialIconSet.BRIGHT).flags(new MaterialFlag[]{MaterialFlags.GENERATE_PLATE, MaterialFlags.GENERATE_DENSE}).components(new Object[]{GTMaterials.Trinium, 6, GTMaterials.Naquadah, 2, GTMaterials.Carbon, 1}).blastTemp(8747, BlastProperty.GasTier.HIGHER, GTValues.VA[7], 1200).buildAndRegister();
    public static Material Fluorite = new Material.Builder(GCYR.id("fluorite")).gem().ore().color(825673).iconSet(MaterialIconSet.DIAMOND).components(new Object[]{GTMaterials.Calcium, 1, GTMaterials.Fluorine, 2}).buildAndRegister();
    public static Material CobaltBromide = new Material.Builder(GCYR.id("cobalt_bromide")).fluid().colorAverage().flags(new MaterialFlag[]{MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING}).components(new Object[]{GTMaterials.Cobalt, 1, GTMaterials.Bromine, 1, GTMaterials.AceticAcid, 1}).buildAndRegister();
    public static Material IronOxide = new Material.Builder(GCYR.id("iron_oxide")).dust().color(12399892).flags(new MaterialFlag[]{MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING}).components(new Object[]{GTMaterials.Iron, 2, GTMaterials.Oxygen, 3}).buildAndRegister();
    public static Material MartianRockDust = new Material.Builder(GCYR.id("martian_rock_dust")).dust().color(11217934).buildAndRegister();
    public static Material ManganeseBromide = new Material.Builder(GCYR.id("manganese_bromide")).fluid().colorAverage().flags(new MaterialFlag[]{MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING}).components(new Object[]{GTMaterials.Manganese, 1, GTMaterials.Bromine, 1, GTMaterials.AceticAcid, 1}).buildAndRegister();
    public static Material ManganeseAcetate = new Material.Builder(GCYR.id("manganese_acetate")).fluid().colorAverage().flags(new MaterialFlag[]{MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING}).components(new Object[]{GTMaterials.Manganese, 1, GTMaterials.AceticAcid, 1}).buildAndRegister();
    public static Material HydrobromicAcid = new Material.Builder(GCYR.id("hydrobromic_acid")).fluid().colorAverage().flags(new MaterialFlag[]{MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING}).components(new Object[]{GTMaterials.Hydrogen, 1, GTMaterials.Bromine, 1, GTMaterials.Water, 1}).buildAndRegister();
    public static Material CoMnBrCatalyst = new Material.Builder(GCYR.id("co_mn_br_catalyst")).fluid().colorAverage().components(new Object[]{CobaltBromide, 1, ManganeseBromide, 1, ManganeseAcetate, 1, HydrobromicAcid, 1}).buildAndRegister();
    public static final Material FiberGlass = new Material.Builder(GCYR.id("fiberglass")).polymer(1).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(1531)).color(13097425).iconSet(MaterialIconSet.SHINY).flags(new MaterialFlag[]{MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_PLATE, MaterialFlags.GENERATE_FOIL, MaterialFlags.NO_SMASHING, MaterialFlags.NO_WORKING}).components(new Object[]{GTMaterials.Epoxy, 2, GTMaterials.SiliconDioxide, 7}).buildAndRegister();
    public static final Material PyromelliticDianhydride = new Material.Builder(GCYR.id("pyrometillic_dianhydride")).dust().fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).color(11832419).components(new Object[]{GTMaterials.Carbon, 10, GTMaterials.Hydrogen, 2, GTMaterials.Oxygen, 6}).buildAndRegister().setFormula("C6H2(C2O3)2", true);
    public static final Material Durene = new Material.Builder(GCYR.id("durene")).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).color(11832419).components(new Object[]{GTMaterials.Carbon, 10, GTMaterials.Hydrogen, 14}).buildAndRegister().setFormula("C6H2(CH3)4", true);
    public static final Material Dimethylformamide = new Material.Builder(GCYR.id("dimethylformamide")).fluid().color(5588073).flags(new MaterialFlag[]{MaterialFlags.DISABLE_DECOMPOSITION}).components(new Object[]{GTMaterials.Carbon, 3, GTMaterials.Hydrogen, 7, GTMaterials.Nitrogen, 1, GTMaterials.Oxygen, 1}).buildAndRegister().setFormula("(CH3)2NC(O)H", true);
    public static final Material Oxydianiline = new Material.Builder(GCYR.id("oxydianiline")).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).color(16428768).components(new Object[]{GTMaterials.Carbon, 12, GTMaterials.Hydrogen, 12, GTMaterials.Nitrogen, 2, GTMaterials.Oxygen, 1}).buildAndRegister();
    public static final Material OxydianilineSludge = new Material.Builder(GCYR.id("oxydianiline_sludge")).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).color(14273727).components(new Object[]{Oxydianiline, 1, Dimethylformamide, 1}).buildAndRegister();
    public static final Material KaptonK = new Material.Builder(GCYR.id("kapton_k")).polymer(1).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).color(9525795).appendFlags((Collection)GTMaterials.STD_METAL, new MaterialFlag[]{MaterialFlags.GENERATE_FOIL}).components(new Object[]{PyromelliticDianhydride, 1, Oxydianiline, 1}).buildAndRegister();
    public static final Material ParaXylene = new Material.Builder(GCYR.id("para_xylene")).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).colorAverage().components(new Object[]{GTMaterials.Carbon, 8, GTMaterials.Hydrogen, 10}).buildAndRegister();
    public static final Material BisTrichloromethylBenzene = new Material.Builder(GCYR.id("bis_trichloromethyl_benzene")).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).color(11832419).components(new Object[]{GTMaterials.Carbon, 8, GTMaterials.Hydrogen, 4, GTMaterials.Chlorine, 6}).buildAndRegister().setFormula("C6H4(CCl3)2", true);
    public static final Material TerephthalicAcid = new Material.Builder(GCYR.id("therephthalic_acid")).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().attribute(FluidAttributes.ACID)).color(14390132).components(new Object[]{GTMaterials.Carbon, 6, GTMaterials.Hydrogen, 4, GTMaterials.CarbonDioxide, 2, GTMaterials.Hydrogen, 2}).buildAndRegister().setFormula("C6H4(CO2H)2", true);
    public static final Material TerephthaloylChloride = new Material.Builder(GCYR.id("terephthaloyl_chloride")).fluid().color(12092382).components(new Object[]{GTMaterials.Carbon, 8, GTMaterials.Hydrogen, 4, GTMaterials.Chlorine, 2, GTMaterials.Oxygen, 2}).buildAndRegister();
    public static final Material Nitroaniline = new Material.Builder(GCYR.id("nitroaniline")).fluid().colorAverage().components(new Object[]{GTMaterials.Carbon, 8, GTMaterials.Hydrogen, 4, GTMaterials.Chlorine, 2, GTMaterials.Oxygen, 2}).buildAndRegister();
    public static final Material ParaPhenylenediamine = new Material.Builder(GCYR.id("para_phenylenediamine")).fluid().color(12836483).components(new Object[]{GTMaterials.Nitrochlorobenzene, 1, GTMaterials.Ammonia, 1}).buildAndRegister();
    public static final Material ParaAramid = new Material.Builder(GCYR.id("para_aramid")).polymer(2).fluid(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(493)).color(15134075).appendFlags((Collection)GTMaterials.STD_METAL, new MaterialFlag[]{MaterialFlags.GENERATE_FOIL}).components(new Object[]{ParaPhenylenediamine, 1, TerephthaloylChloride, 1}).fluidPipeProperties(1500, 450, true, true, true, false).buildAndRegister();

    public static void init() {
    }

    public static void modifyMaterials() {
        GTMaterials.IronMagnetic.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_FOIL});
        GTMaterials.TitaniumTungstenCarbide.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_ROD});
        GTMaterials.Titanium.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
    }
}

