/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.data;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.api.registries.GCYRRegistries;
import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.api.space.satellite.SatelliteType;
import argent_matter.gcyr.common.satellite.DysonSwarmSatellite;
import argent_matter.gcyr.common.satellite.EmptySatellite;
import argent_matter.gcyr.common.satellite.GpsSatellite;
import argent_matter.gcyr.common.satellite.LaserSatellite;
import argent_matter.gcyr.common.satellite.OreFinderSatellite;
import net.minecraft.resources.ResourceLocation;

public class GCYRSatellites {
    public static final SatelliteType<EmptySatellite> EMPTY;
    public static final SatelliteType<GpsSatellite> GPS;
    public static final SatelliteType<OreFinderSatellite> ORE_FINDER;
    public static final SatelliteType<LaserSatellite> LASER;
    public static final SatelliteType<DysonSwarmSatellite> DYSON_SWARM;

    public static <T extends Satellite> SatelliteType<T> register(String name, SatelliteType<T> satellite) {
        ResourceLocation id = GCYR.id(name);
        GCYRRegistries.SATELLITES.register((Object)id, satellite);
        return satellite;
    }

    public static void init() {
        GCYRRegistries.SATELLITES.freeze();
    }

    static {
        GCYRRegistries.SATELLITES.unfreeze();
        EMPTY = GCYRSatellites.register("empty", new SatelliteType<EmptySatellite>(EmptySatellite::new, EmptySatellite.CODEC));
        GPS = GCYRSatellites.register("gps", new SatelliteType<GpsSatellite>(GpsSatellite::new, GpsSatellite.CODEC));
        ORE_FINDER = GCYRSatellites.register("ore_finder", new SatelliteType<OreFinderSatellite>(OreFinderSatellite::new, OreFinderSatellite.CODEC));
        LASER = GCYRSatellites.register("laser", new SatelliteType<LaserSatellite>(LaserSatellite::new, LaserSatellite.CODEC));
        DYSON_SWARM = GCYRSatellites.register("dyson_swarm", new SatelliteType<DysonSwarmSatellite>(DysonSwarmSatellite::new, DysonSwarmSatellite.CODEC));
    }
}

