/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.item;

import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.data.loader.PlanetData;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class KeyCardBehaviour
implements IAddInformation {
    @Nullable
    public static UUID getOwner(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128425_("KeyCardOwner", 11)) {
            return stack.m_41783_().m_128342_("KeyCardOwner");
        }
        return null;
    }

    public static void setOwner(ItemStack stack, LivingEntity entity) {
        stack.m_41784_().m_128362_("KeyCardOwner", entity.m_20148_());
    }

    public static void setSavedStation(ItemStack stack, @Nullable Integer stationId, Planet planet) {
        if (!GCYRItems.KEYCARD.isIn(stack)) {
            return;
        }
        if (stationId == null) {
            return;
        }
        stack.m_41784_().m_128405_("gcyr:current_station", stationId.intValue());
        stack.m_41783_().m_128359_("gcyr:current_planet", PlanetData.getPlanetId(planet).toString());
    }

    public static Integer getSavedStation(ItemStack stack) {
        if (!GCYRItems.KEYCARD.isIn(stack)) {
            return null;
        }
        return stack.m_41784_().m_128451_("gcyr:current_station");
    }

    @Nullable
    public static Planet getSavedPlanet(ItemStack stack) {
        if (!GCYRItems.KEYCARD.isIn(stack)) {
            return null;
        }
        return PlanetData.getPlanet(new ResourceLocation(stack.m_41784_().m_128461_("gcyr:current_planet")));
    }

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (!level.f_46443_ && !itemStack.m_41784_().m_128425_("KeyCardOwner", 11) && player.m_6047_()) {
            KeyCardBehaviour.setOwner(itemStack, (LivingEntity)player);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Integer currentStationId;
        Planet currentTarget = KeyCardBehaviour.getSavedPlanet(stack);
        if (currentTarget != null) {
            tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.planet_id_circuit.id").m_7220_((Component)Component.m_237115_((String)currentTarget.translation())));
        }
        if ((currentStationId = KeyCardBehaviour.getSavedStation(stack)) != null) {
            tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.planet_id_circuit.station", (Object[])new Object[]{currentStationId}));
        }
    }
}

