/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.item;

import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.common.data.GCYRMenus;
import argent_matter.gcyr.data.loader.PlanetData;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlanetIdChipBehaviour
implements IInteractionItem,
IAddInformation {
    public static final String CURRENT_STATION_KEY = "gcyr:current_station";
    public static final String CURRENT_PLANET_KEY = "gcyr:current_planet";

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack heldItem = player.m_21120_(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GCYRMenus.PLANET_SELECTION.open(serverPlayer, (Component)Component.m_237115_((String)"gui.gcyr.planet_selector"), PlanetData::writePlanetData);
            return InteractionResultHolder.m_19096_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public static void setSpaceStation(ItemStack held, int stationId) {
        if (!GCYRItems.ID_CHIP.isIn(held) || stationId == Integer.MIN_VALUE) {
            return;
        }
        held.m_41784_().m_128405_(CURRENT_STATION_KEY, stationId);
    }

    @Nullable
    public static Integer getSpaceStationId(ItemStack held) {
        if (!GCYRItems.ID_CHIP.isIn(held) || !held.m_41784_().m_128425_(CURRENT_STATION_KEY, 3)) {
            return null;
        }
        return held.m_41784_().m_128451_(CURRENT_STATION_KEY);
    }

    @Nullable
    public static Planet getPlanetFromStack(ItemStack stack) {
        return PlanetData.getPlanetFromLevelOrOrbit((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(stack.m_41784_().m_128461_(CURRENT_PLANET_KEY)))).orElse(null);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Integer currentStationId;
        Planet currentTarget = PlanetIdChipBehaviour.getPlanetFromStack(stack);
        if (currentTarget != null) {
            tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.planet_id_circuit.id").m_7220_((Component)Component.m_237115_((String)currentTarget.translation())));
        }
        if ((currentStationId = PlanetIdChipBehaviour.getSpaceStationId(stack)) != null) {
            tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.planet_id_circuit.station", (Object[])new Object[]{currentStationId}));
        }
    }
}

