/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.machine.electric;

import argent_matter.gcyr.common.entity.data.EntityOxygenSystem;
import argent_matter.gcyr.util.FloodFiller3D;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import org.joml.Vector3f;

public class OxygenSpreaderMachine
extends SimpleTieredMachine {
    public static long tankScalingFunction(int tier) {
        return (long)(tier * 4) * FluidHelper.getBucket();
    }

    public OxygenSpreaderMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, OxygenSpreaderMachine::tankScalingFunction, args);
    }

    public void afterWorking() {
        super.afterWorking();
        this.runAlgorithm();
    }

    public boolean canDistribute(int oxygenBlocks) {
        return ((FluidIngredient)((Content)this.recipeLogic.getLastRecipe().getInputContents((RecipeCapability)FluidRecipeCapability.CAP).get((int)0)).content).getAmount() / FluidHelper.getBucket() >= (long)oxygenBlocks;
    }

    public void runAlgorithm() {
        Set<BlockPos> positions = FloodFiller3D.run(this.getLevel(), this.getPos(), this.getFrontFacing());
        if (this.canDistribute(positions.size())) {
            EntityOxygenSystem.setEntry(this.getLevel(), this.getPos(), positions);
        } else if (!this.getLevel().m_5776_()) {
            EntityOxygenSystem.removeEntry(this.getLevel(), this.getPos());
        }
        this.spawnParticles(positions);
    }

    public void spawnParticles(Set<BlockPos> positions) {
        if (!this.getLevel().m_5776_()) {
            for (BlockPos pos : positions) {
                this.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.5, 0.5, 0.5);
            }
        }
    }
}

