/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.satellite;

import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.api.space.satellite.SatelliteType;
import argent_matter.gcyr.api.space.satellite.data.SatelliteData;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.ArrayUtils;

public class OreFinderSatellite
extends Satellite {
    public static final Codec<OreFinderSatellite> CODEC = RecordCodecBuilder.create(instance -> Satellite.baseCodec(instance).apply((Applicative)instance, OreFinderSatellite::new));
    public static final int CELL_SIZE = 32;
    private BlockPos centerPos;

    public OreFinderSatellite(SatelliteType<?> type, SatelliteData data, ResourceKey<Level> level) {
        super(type, data, level);
    }

    @Override
    public void tickSatellite(Level level) {
        if (this.isNonWorking()) {
            return;
        }
    }

    @Override
    public boolean runSatelliteFunction(Level level) {
        return false;
    }

    public void scan(BlockState[][][] storage, Level level) {
        LevelChunk chunk = level.m_46745_(this.centerPos);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        TagKey oreTag = TagUtil.createBlockTag((String)"ores");
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (storage[x][z] != null) continue;
                for (int y = chunk.m_151558_() - 1; y >= chunk.m_141937_(); --y) {
                    pos.m_122178_(x, y, z);
                    BlockState state = chunk.m_8055_((BlockPos)pos);
                    if (!state.m_204336_(oreTag)) continue;
                    storage[x][z] = (BlockState[])ArrayUtils.add((Object[])storage[x][z], (Object)state);
                }
            }
        }
    }

    public CompoundTag serializeExtraData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("centerPos", (Tag)NbtUtils.m_129224_((BlockPos)this.centerPos));
        return tag;
    }

    @Override
    public void deserializeExtraData(Tag tag, Level level) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.centerPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("centerPos"));
        }
    }
}

