/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.data.loader;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.GCYRClient;
import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.common.data.GCYRNetworking;
import argent_matter.gcyr.common.networking.c2s.PacketRequestPlanetData;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PlanetData
extends SimpleJsonResourceReloadListener {
    private static final BiMap<ResourceLocation, Planet> PLANETS = HashBiMap.create();
    private static final BiMap<ResourceLocation, List<Planet>> SOLAR_SYSTEMS = HashBiMap.create();
    private static final BiMap<ResourceKey<Level>, Planet> LEVEL_TO_PLANET = HashBiMap.create();
    private static final Map<ResourceKey<Level>, Planet> ORBIT_TO_PLANET = new HashMap<ResourceKey<Level>, Planet>();
    private static final Set<ResourceKey<Level>> PLANET_LEVELS = new HashSet<ResourceKey<Level>>();
    private static final Set<ResourceKey<Level>> ORBITS_LEVELS = new HashSet<ResourceKey<Level>>();
    private static final Set<ResourceKey<Level>> OXYGEN_LEVELS = new HashSet<ResourceKey<Level>>();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public PlanetData() {
        super(GSON, "gcyr/planets");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_6180_("Gregicality Rocketry Planet Deserialization");
        HashMap<ResourceLocation, Planet> planets = new HashMap<ResourceLocation, Planet>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"planet");
            Planet newPlanet = (Planet)Planet.DIRECT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0));
            planets.entrySet().removeIf(planet -> ((Planet)planet.getValue()).level().equals(newPlanet.level()));
            planets.put(entry.getKey(), newPlanet);
        }
        PlanetData.updatePlanets(planets);
        profiler.m_7238_();
    }

    public static void updatePlanets(Map<ResourceLocation, Planet> planets) {
        PlanetData.clear();
        for (Map.Entry<ResourceLocation, Planet> entry : planets.entrySet()) {
            ResourceLocation id = entry.getKey();
            Planet planet = entry.getValue();
            PLANETS.put((Object)id, (Object)planet);
            ((List)SOLAR_SYSTEMS.computeIfAbsent((Object)planet.solarSystem(), system -> new ArrayList())).add(planet);
            LEVEL_TO_PLANET.put(planet.level(), (Object)planet);
            ORBIT_TO_PLANET.put(planet.orbitWorld(), planet);
            PLANET_LEVELS.add(planet.level());
            ORBITS_LEVELS.add(planet.orbitWorld());
            if (!planet.hasOxygen()) continue;
            OXYGEN_LEVELS.add(planet.level());
        }
    }

    private static void clear() {
        PLANETS.clear();
        LEVEL_TO_PLANET.clear();
        ORBIT_TO_PLANET.clear();
        PLANET_LEVELS.clear();
        ORBITS_LEVELS.clear();
        OXYGEN_LEVELS.clear();
    }

    public static void writePlanetData(FriendlyByteBuf buf) {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry entry : PLANETS.entrySet()) {
            nbt.m_128365_(((ResourceLocation)entry.getKey()).toString(), (Tag)Planet.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((Planet)entry.getValue())).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
        }
        buf.m_130079_(nbt);
    }

    public static void readPlanetData(FriendlyByteBuf buf) {
        try {
            CompoundTag nbt = buf.m_130260_();
            if (nbt == null) {
                PlanetData.updatePlanets(Map.of());
                return;
            }
            HashMap<ResourceLocation, Planet> planets = new HashMap<ResourceLocation, Planet>();
            for (String key : nbt.m_128431_()) {
                planets.put(ResourceLocation.m_135820_((String)key), (Planet)Planet.DIRECT_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_(key)).result().orElseThrow());
            }
            PlanetData.updatePlanets(planets);
        }
        catch (Exception e) {
            GCYR.LOGGER.error("Failed to parse planet data!");
            e.printStackTrace();
            PlanetData.updatePlanets(Map.of());
        }
    }

    public static Map<ResourceLocation, Planet> planets() {
        return PLANETS;
    }

    @Nullable
    public static ResourceLocation getPlanetId(Planet planet) {
        return (ResourceLocation)PLANETS.inverse().get((Object)planet);
    }

    @Nullable
    public static Planet getPlanet(ResourceLocation id) {
        return (Planet)PLANETS.get((Object)id);
    }

    public static List<Planet> getSolarSystemPlanets(ResourceLocation solarSystemId) {
        return (List)SOLAR_SYSTEMS.get((Object)solarSystemId);
    }

    public static Optional<Planet> getPlanetFromLevel(ResourceKey<Level> level) {
        return Optional.ofNullable((Planet)LEVEL_TO_PLANET.get(level));
    }

    public static Optional<Planet> getPlanetFromOrbit(ResourceKey<Level> level) {
        return Optional.ofNullable(ORBIT_TO_PLANET.get(level));
    }

    public static Optional<Planet> getPlanetFromLevelOrOrbit(ResourceKey<Level> level) {
        return Optional.ofNullable(PlanetData.getPlanetFromLevel(level).orElseGet(() -> PlanetData.getPlanetFromOrbit(level).orElse(null)));
    }

    public static Optional<ResourceKey<Level>> getLevelFromPlanet(Planet planet) {
        return Optional.ofNullable((ResourceKey)LEVEL_TO_PLANET.inverse().get((Object)planet));
    }

    public static boolean isOrbitLevel(ResourceKey<Level> level) {
        return ORBITS_LEVELS.contains(level);
    }

    public static boolean isPlanetLevel(Level level) {
        if (level.f_46443_ && !GCYRClient.hasUpdatedPlanets) {
            GCYRNetworking.NETWORK.sendToServer((IPacket)new PacketRequestPlanetData());
            GCYRClient.hasUpdatedPlanets = true;
        }
        return PLANET_LEVELS.contains(level.m_46472_());
    }

    public static boolean isOxygenated(Level level) {
        return OXYGEN_LEVELS.contains(level.m_46472_()) || !PlanetData.isSpaceLevel(level);
    }

    public static boolean isSpaceLevel(Level level) {
        return PlanetData.isPlanetLevel(level) || PlanetData.isOrbitLevel((ResourceKey<Level>)level.m_46472_());
    }

    public static float getWorldTemperature(Level level) {
        if (PlanetData.isOrbitLevel((ResourceKey<Level>)level.m_46472_())) {
            return 3.0f;
        }
        return PlanetData.getPlanetFromLevel((ResourceKey<Level>)level.m_46472_()).map(Planet::temperature).orElse(Float.valueOf(293.0f)).floatValue();
    }
}

