/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.util;

import argent_matter.gcyr.config.GCYRConfig;
import argent_matter.gcyr.data.recipe.GCYRTags;
import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloodFiller3D {
    public static Set<BlockPos> run(Level level, BlockPos start, Direction startFacing) {
        LinkedHashSet<BlockPos> positions = new LinkedHashSet<BlockPos>();
        LinkedHashSet<Pair> queue = new LinkedHashSet<Pair>();
        queue.add(Pair.of((Object)start, (Object)startFacing));
        while (!queue.isEmpty() && positions.size() < GCYRConfig.INSTANCE.server.maxOxygenatedBlockChecks) {
            Iterator iterator = queue.iterator();
            Pair pair = (Pair)iterator.next();
            BlockPos pos = ((BlockPos)pair.getFirst()).m_121945_((Direction)pair.getSecond());
            iterator.remove();
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(GCYRTags.BLOCKS_FLOOD_FILL)) continue;
            VoxelShape collisionShape = state.m_60812_((BlockGetter)level, pos);
            if (!state.m_60795_() && !state.m_204336_(GCYRTags.PASSES_FLOOD_FILL) && !collisionShape.m_83281_() && FloodFiller3D.isSideSolid(collisionShape, (Direction)pair.getSecond(), state) && (FloodFiller3D.isFaceSturdy(collisionShape, (Direction)pair.getSecond(), state) || FloodFiller3D.isFaceSturdy(collisionShape, ((Direction)pair.getSecond()).m_122424_(), state))) continue;
            positions.add(pos);
            for (Direction dir : Direction.values()) {
                if (positions.contains(pos.m_121945_(dir))) continue;
                queue.add(Pair.of((Object)pos, (Object)dir));
            }
        }
        return positions;
    }

    private static boolean isSideSolid(VoxelShape collisionShape, Direction dir, BlockState state) {
        return FloodFiller3D.checkBounds(collisionShape.m_83215_(), dir.m_122434_());
    }

    private static boolean isFaceSturdy(VoxelShape collisionShape, Direction dir, BlockState state) {
        VoxelShape faceShape = collisionShape.m_83263_(dir);
        if (faceShape.m_83281_()) {
            return true;
        }
        return FloodFiller3D.checkBounds((AABB)faceShape.m_83299_().get(0), dir.m_122434_());
    }

    private static boolean checkBounds(AABB bounds, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (bounds.f_82289_ <= 0.0 && bounds.f_82292_ >= 1.0 && bounds.f_82290_ <= 0.0 && bounds.f_82293_ >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (bounds.f_82288_ <= 0.0 && bounds.f_82291_ >= 1.0 && bounds.f_82290_ <= 0.0 && bounds.f_82293_ >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> bounds.f_82288_ <= 0.0 && bounds.f_82291_ >= 1.0 && bounds.f_82289_ <= 0.0 && bounds.f_82292_ >= 1.0;
        };
    }
}

