/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.util;

import argent_matter.gcyr.api.capability.GCYRCapabilityHelper;
import argent_matter.gcyr.api.capability.ISpaceStationHolder;
import argent_matter.gcyr.api.space.station.SpaceStation;
import argent_matter.gcyr.data.loader.PlanetData;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import org.jetbrains.annotations.Nullable;

public class MixinHelpers {
    public static WorldBorder modifySpaceStationBorder(WorldBorder original, @Nullable Entity entity) {
        Level level;
        if (entity != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (PlanetData.isOrbitLevel((ResourceKey<Level>)serverLevel.m_46472_())) {
                ISpaceStationHolder spaceStationHolder = GCYRCapabilityHelper.getSpaceStations(serverLevel);
                if (spaceStationHolder == null) {
                    return original;
                }
                List<Integer> stationIds = spaceStationHolder.getStationsNearWorldPos(entity.m_20183_(), SpaceStation.BLOCK_MULTIPLIER / 2);
                if (!stationIds.isEmpty()) {
                    WorldBorder border;
                    int nearest = stationIds.get(0);
                    SpaceStation station = spaceStationHolder.getStation(nearest);
                    WorldBorder worldBorder = border = station != null ? station.border() : original;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        if (player.f_8906_ != null) {
                            player.f_8906_.m_9829_((Packet)new ClientboundSetBorderCenterPacket(border));
                            player.f_8906_.m_9829_((Packet)new ClientboundSetBorderSizePacket(border));
                        }
                    }
                    return border;
                }
            } else if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.f_8906_ != null) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSetBorderCenterPacket(original));
                    player.f_8906_.m_9829_((Packet)new ClientboundSetBorderSizePacket(original));
                }
            }
        }
        return original;
    }
}

