/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.satellite;

import argent_matter.gcyr.api.registries.GCYRRegistries;
import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.api.space.satellite.data.SatelliteData;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SatelliteType<T extends Satellite> {
    private final Supplier<T> defaultInstance;
    private final SatelliteFactory<T> factory;
    private final Codec<T> codec;

    public SatelliteType(SatelliteFactory<T> factory, Codec<T> codec) {
        this.factory = factory;
        this.defaultInstance = () -> factory.create(this, SatelliteData.DEFAULT, (ResourceKey<Level>)Level.f_46428_);
        this.codec = codec;
    }

    public String toLangString() {
        ResourceLocation id = (ResourceLocation)GCYRRegistries.SATELLITES.getKey((Object)this);
        return id.m_135827_() + ".satellite." + id.m_135815_();
    }

    public Supplier<T> getDefaultInstance() {
        return this.defaultInstance;
    }

    public SatelliteFactory<T> getFactory() {
        return this.factory;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    @FunctionalInterface
    public static interface SatelliteFactory<T extends Satellite> {
        public T create(SatelliteType<?> var1, SatelliteData var2, ResourceKey<Level> var3);
    }
}

