/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.station;

import argent_matter.gcyr.api.capability.ISpaceStationHolder;
import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.api.space.station.SpaceStation;
import argent_matter.gcyr.data.loader.PlanetData;
import argent_matter.gcyr.util.Vec2i;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StationWorldSavedData
extends SavedData
implements ISpaceStationHolder {
    private final Int2ObjectMap<SpaceStation> stations = new Int2ObjectLinkedOpenHashMap(1);
    private final Int2ObjectMap<Vec2i> freeStationPositions = new Int2ObjectLinkedOpenHashMap(961);
    private final ServerLevel level;

    @Nullable
    public static StationWorldSavedData getOrCreate(@Nullable ServerLevel serverLevel) {
        if (serverLevel == null) {
            return null;
        }
        if (!PlanetData.isOrbitLevel((ResourceKey<Level>)serverLevel.m_46472_())) {
            Planet planet = PlanetData.getPlanetFromLevel((ResourceKey<Level>)serverLevel.m_46472_()).orElse(null);
            if (planet == null) {
                return null;
            }
            ServerLevel orbit = serverLevel.m_7654_().m_129880_(planet.orbitWorld());
            return StationWorldSavedData.getOrCreate(orbit);
        }
        return (StationWorldSavedData)serverLevel.m_8895_().m_164861_(tag -> new StationWorldSavedData(serverLevel, (CompoundTag)tag), () -> new StationWorldSavedData(serverLevel), "gcyr_space_stations");
    }

    public StationWorldSavedData(ServerLevel level) {
        this.level = level;
        for (int x = 0; x < 31; ++x) {
            for (int y = 0; y < 31; ++y) {
                this.freeStationPositions.put(y + x * 31, (Object)new Vec2i(x, y));
            }
        }
    }

    public StationWorldSavedData(ServerLevel level, CompoundTag tag) {
        this(level);
        this.load(tag);
    }

    @Override
    public Int2ObjectMap<SpaceStation> getStations() {
        return this.stations;
    }

    @Override
    public int getClosestStationId(Vec2i position) {
        Int2ObjectMap.Entry result = this.stations.int2ObjectEntrySet().stream().min(Comparator.comparingDouble(obj -> ((SpaceStation)obj.getValue()).position().distanceToSqr(position))).orElse(null);
        return result == null ? -1 : result.getIntKey();
    }

    @Override
    @Nullable
    public Vec2i getStationPos(int id) {
        SpaceStation station = (SpaceStation)this.stations.get(id);
        if (station == null) {
            return null;
        }
        return station.position();
    }

    @Override
    @Nullable
    public SpaceStation getStation(@Nullable Integer id) {
        if (id == null) {
            return null;
        }
        return (SpaceStation)this.stations.get(id.intValue());
    }

    @Override
    @Nullable
    public BlockPos getStationWorldPos(int id) {
        Vec2i stationPos = this.getStationPos(id);
        if (stationPos == null) {
            return null;
        }
        return new BlockPos(stationPos.x() * SpaceStation.BLOCK_MULTIPLIER, 63, stationPos.y() * SpaceStation.BLOCK_MULTIPLIER);
    }

    @Override
    public List<Integer> getStationsNearPos(Vec2i position, int range) {
        return this.stations.int2ObjectEntrySet().stream().filter(obj -> ((SpaceStation)obj.getValue()).position().distanceToSqr(position) <= range * range).sorted(Map.Entry.comparingByKey()).map(Int2ObjectMap.Entry::getIntKey).collect(Collectors.toList());
    }

    @Override
    public void addStation(int stationId, SpaceStation pos) {
        this.stations.put(stationId, (Object)pos);
        this.freeStationPositions.remove(stationId, (Object)pos);
        this.m_77762_();
    }

    @Override
    public void destroyStation(int id) {
        this.freeStationPositions.put(id, (Object)((SpaceStation)this.stations.get(id)).position());
        this.stations.remove(id);
        this.m_77762_();
    }

    @Override
    public int getFreeStationId() {
        return this.stations.size();
    }

    @Override
    public Vec2i getFreeStationPos(int stationId) {
        return (Vec2i)this.freeStationPositions.getOrDefault(stationId, (Object)Vec2i.MAX_NEGATIVE);
    }

    public void load(CompoundTag arg) {
        CompoundTag stationsTag = arg.m_128469_("stations");
        for (String name : stationsTag.m_128431_()) {
            CompoundTag tag = stationsTag.m_128469_(name);
            int id = Integer.parseInt(name);
            SpaceStation station = (SpaceStation)SpaceStation.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseThrow();
            this.stations.put(id, (Object)station);
            this.freeStationPositions.remove(id);
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        CompoundTag tag = new CompoundTag();
        for (Int2ObjectMap.Entry entry : this.stations.int2ObjectEntrySet()) {
            Tag station = (Tag)SpaceStation.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((SpaceStation)entry.getValue())).result().orElseThrow();
            tag.m_128365_(Integer.toString(entry.getIntKey()), station);
        }
        compoundTag.m_128365_("stations", (Tag)tag);
        return compoundTag;
    }
}

